;; Red Hat Linux default .emacs initialization file

;; Set up the keyboard so the delete key on both the regular keyboard
;; and the keypad delete the character under the cursor and to the right
;; under X, instead of the default, backspace behavior.
(global-set-key [delete] 'delete-char)
(global-set-key [kp-delete] 'delete-char)

;;load-file RET ~/.emacs RET'.

;;;
;;; There is a great deal of documentation on customization in the Emacs
;;; manual.  You can read this manual with the online Info browser: type
;;; `C-h i' or select "Emacs Info" from the "Help" menu.
;;;
;;; ***************************************************************** 
;;;
;;; To make changes to this file effective in the current session: 
;;;
;;;   load the file into a buffer 
;;;   make changes 
;;;   compile the buffer       cmd:     ESC-x  byte-compile-buffer
;;;
;;; To make the changes permanent: 
;;;
;;;   compile the file         cmd:     ESC-x  byte-compile-file 
;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;			Basic Customization			    ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;---------------------------------------------------------
;; Enable the commands `narrow-to-region' ("C-x n n") and 
;; `eval-expression' ("M-ESC", or "ESC ESC").  Both are useful
;; commands, but they can be confusing for a new user, so they're
;; disabled by default.
;;---------------------------------------------------------

(put 'narrow-to-region 'disabled nil)
(put 'eval-expression 'disabled nil)

;;---------------------------------------------------------
;;; Define a variable to indicate whether we're running XEmacs/Lucid Emacs.
;;; (You do not have to defvar a global variable before using it --
;;; you can just call `setq' directly like we do for `emacs-major-version'
;;; below.  It's clearer this way, though.)
;;---------------------------------------------------------

(defvar running-xemacs (string-match "XEmacs\\|Lucid" emacs-version))

;;---------------------------------------------------------
;; Make the sequence "C-x w" execute the `what-line' command, 
;; which prints the current line number in the echo area.
;;---------------------------------------------------------
(global-set-key "\C-xw" 'what-line)
(global-set-key "\C-="  'what-line)  ;; alias Ctrl-=

;;---------------------------------------------------------
;; set up the function keys to do common tasks to reduce Emacs pinky
;; and such.
;;---------------------------------------------------------


;; Clean up white-space.

(require 'whitespace)

;;(defun curl-code-cleanup ()
;;  "no docs"
;;  (interactive)
;;  (untabify (point-min) (point-max))
;;  (whitespace-cleanup)
;;)

;;(defun curl-code-cleanup-sv ()
;;  "no docs"
;;  (curl-code-cleanup)
;;  (save-buffer)
;;)

;; JC - Make shift-backspace be `undo'
;; Make F1 invoke help
;; Make F2 be `undo'

(global-set-key '(shift backspace) 'undo)
(global-set-key 'f1 'help-command)
(global-set-key 'f2 'undo)

;; Make F3 be `find-file'
;; Note: it does not currently work to say
;;   (global-set-key 'f3 "\C-x\C-f")
;; The reason is that macros can't do interactive things properly.
;; This is an extremely longstanding bug in Emacs.  Eventually,
;; it will be fixed. (Hopefully ..)
(global-set-key 'f3 'find-file)

;; Make F4 be "mark", F5 be "copy", F6 be "paste"
;; Note that you can set a key sequence either to a command or to another
;; key sequence.
(global-set-key 'f4 'set-mark-command)
(global-set-key 'f5 "\M-w")
(global-set-key 'f6 "\C-y")

;; Shift-F4 is "pop mark off of stack"
(global-set-key '(shift f4) (lambda () (interactive) (set-mark-command t)))

;; Make F7 be `save-buffer'
(global-set-key 'f7 'save-buffer)

;; Make F8 be "start macro", F9 be "end macro", F10 be "execute macro"
(global-set-key 'f8 'start-kbd-macro)
(global-set-key 'f9 'end-kbd-macro)
(global-set-key 'f10 'call-last-kbd-macro)

;; Let xemacs colorize larger files, default seems to be 245k --Ben
(setq font-lock-maximum-size 1024000)

;; Here's an alternative binding if you don't use keyboard macros:
;; Make F8 be `save-buffer' followed by `delete-window'.
;;(global-set-key 'f8 "\C-x\C-s\C-x0")

;;---------------------------------------------------------
;; If you prefer delete to actually delete forward then you want to
;; uncomment the next line.
;;---------------------------------------------------------
;; (load-library "delbackspace")


;; Load the GNATS stuff. --Ben


(autoload 'edit-pr "gnats" 
        "Command to edit a problem report." t)
     (autoload 'view-pr "gnats"
        "Command to view a problem report." t)
     (autoload 'unlock-pr "gnats"
        "Unlock a problem report." t)
     (autoload 'query-pr "gnats"
        "Command to query information about problem reports." t)
     (autoload 'send-pr-mode "send-pr"
        "Major mode for sending problem reports." t)
     (autoload 'send-pr "send-pr"
        "Command to create and send a problem report." t)

;;---------------------------------------------------------
;; Enable double sided printing 
;;---------------------------------------------------------

;;(setq lpr-switches (list "-oduplex"))
;;(require 'ps-print)
;;(setq ps-lpr-switches "-oduplex")
;;(setq ps-spool-duplex t)

;;---------------------------------------------------------
;; add to load-path for additional packages for emacs
;;---------------------------------------------------------

(setq load-path (cons "/home/greearb/elisp" load-path))
(setq load-path (cons "\\\\File-server\\greear\\elisp" load-path))

;;---------------------------------------------------------
;; Hscroll: Horizontal Scroll
;;---------------------------------------------------------

(load "hscroll")

;;---------------------------------------------------------
;; Multiple file search and replace
;;---------------------------------------------------------

(autoload 'global-replace-lines "global-replace"
          "Put back grepped lines" t)
(autoload 'global-replace "global-replace"
          "query-replace across files" t)
(autoload 'global-grep-and-replace "global-replace"
          "grep and query-replace across files" t)

;;---------------------------------------------------------
;; Cycle: Treat buffer stack as a ring
;;---------------------------------------------------------

(load "cycle")

(global-set-key '(control kp_subtract) 'cycle-buffer-prev)
(global-set-key '(control kp_add)      'cycle-buffer-next)
(global-set-key '(control kp_multiply) 'switch-to-other-buffer) ; most recent

;;---------------------------------------------------------
;; Flip: locate associated .C or .H file 
;;---------------------------------------------------------

(load "emacs-flip")

(global-set-key '(control kp_enter)    'flip)

;;---------------------------------------------------------
;; Include: visit file named on #include line 
;;---------------------------------------------------------

(load "include")

(global-set-key '(shift kp_enter)    'locate-include-file)

;;---------------------------------------------------------
;; Project Specific Customization
;;---------------------------------------------------------

;(load "em-project")

;(setq my-include-dirs 
;  (list
;    (concat (getenv "EM_DEVPATH") "/include_public/")
;    (concat (getenv "EM_DEVPATH") "/include_private/")
;    (concat (getenv "ATIUM_DV_HOME") "/include_public/")
;    (concat (getenv "ATIUM_DV_HOME") "/include_private/")
;    '"/opt/OV/include/"));
;
;;(setq my-cpp-include-dirs 
;;   '("/opt/SUNWspro/SC3.0/include/CC/"
;;     "/usr/include"));;;
;
;(setq my-cpp-include-dirs 
;   (list 
;    '"./"
;    (concat (getenv "EM_DEVPATH") "/include_public/")
;    (concat (getenv "EM_DEVPATH") "/include_private/")
;    (concat (getenv "ATIUM_DV_HOME") "/include_public/")
;    (concat (getenv "ATIUM_DV_HOME") "/include_private/")
;     '"/opt/OV/include/"
;     '"/opt/SUNWspro/SC3.0/include/CC/"
;     '"/usr/include"));
;

;;---------------------------------------------------------
;;---------------------------------------------------------

(cond (running-xemacs
       ;;
       ;; Code for any version of XEmacs/Lucid Emacs goes here
       ;;

       ;; Change the values of some variables.
       ;; (t means true; nil means false.)
       ;;
       ;; Use the "Describe Variable..." option on the "Help" menu
       ;; to find out what these variables mean.
       (setq find-file-use-truenames nil
	     find-file-compare-truenames t
	     minibuffer-confirm-incomplete t
	     complex-buffers-menu-p t
	     next-line-add-newlines nil
	     mail-yank-prefix "> "
	     kill-whole-line t
	     )

       ;; When running ispell, consider all 1-3 character words as correct.
       (setq ispell-extra-args '("-W" "3"))

       ;; Change the way the buffer name is displayed in the
       ;; modeline.  The variable for this is called
       ;; 'modeline-buffer-identification but was called
       ;; 'mode-line-buffer-identification in older XEmacsen.
       (if (boundp 'modeline-buffer-identification)
	   ;; Note that if you want to put more than one form in the
	   ;; `THEN' clause of an IF-THEN-ELSE construct, you have to
	   ;; surround the forms with `progn'.  You don't have to
	   ;; do this for the `ELSE' clause.
	   (progn
	     (setq-default modeline-buffer-identification '("XEmacs: %17b"))
	     (setq         modeline-buffer-identification '("XEmacs: %17b")))
	 ;;(setq-default mode-line-buffer-identification '("XEmacs: %17b"))
	 ;;(setq         mode-line-buffer-identification '("XEmacs: %17b"))
	 )

       (cond ((or (not (fboundp 'device-type))
		  (equal (device-type) 'x))
	      ;;
	      ;; Code which applies only when running emacs under X goes here.
	      ;; (We check whether the function `device-type' exists
	      ;; before using it.  In versions before 19.12, there
	      ;; was no such function.  If it doesn't exist, we
	      ;; simply assume we're running under X -- versions before
	      ;; 19.12 only supported X.)

	      ;; Remove the binding of C-x C-c, which normally exits emacs.
	      ;; It's easy to hit this by mistake, and that can be annoying.
	      ;; Under X, you can always quit with the "Exit Emacs" option on
	      ;; the File menu.
	      ;; (global-set-key "\C-x\C-c" nil)

	      ;; Uncomment this to enable "sticky modifier keys" in 19.13
	      ;; and up.  With sticky modifier keys enabled, you can
	      ;; press and release a modifier key before pressing the
	      ;; key to be modified, like how the ESC key works always.
	      ;; If you hold the modifier key down, however, you still
	      ;; get the standard behavior.  I personally think this
	      ;; is the best thing since sliced bread (and a *major*
	      ;; win when it comes to reducing Emacs pinky), but it's
	      ;; disorienting at first so I'm not enabling it here by
	      ;; default.

	      ;;(setq modifier-keys-are-sticky t)

	      ;; This changes the variable which controls the text that goes
	      ;; in the top window title bar.  (However, it is not changed
	      ;; unless it currently has the default value, to avoid
	      ;; interfering with a -wn command line argument I may have
	      ;; started emacs with.)
;	      (if (equal frame-title-format "%S: %b")
;		  (setq frame-title-format
;			(concat "%S: " invocation-directory invocation-name
;				" [" emacs-version "]"
;				(if nil ; (getenv "NCD")
;				    ""
;				  "   %b"))))
;

	      ;; if we're running on display 0, load some nifty sounds that
	      ;; will replace the default beep.  But if we're running on a
	      ;; display other than 0, which probably means my NCD X terminal,
	      ;; which can't play digitized sounds, do two things: reduce the
	      ;; beep volume a bit, and change the pitch of the sound that is
	      ;; made for "no completions."
	      ;;
	      ;; (Note that sampled sounds only work if XEmacs was compiled
	      ;; with sound support, and we're running on the console of a
	      ;; Sparc, HP, or SGI machine, or on a machine which has a
	      ;; NetAudio server; otherwise, you just get the standard beep.)
	      ;;
	      ;; (Note further that changing the pitch and duration of the
	      ;; standard beep only works with some X servers; many servers
	      ;; completely ignore those parameters.)
	      ;;
;;	      (cond ((string-match ":0" (getenv "DISPLAY"))
;;		     (load-default-sounds))
;;		    (t
;;		     (setq bell-volume 20)
;;		     (setq sound-alist
;;			   (append sound-alist '((no-completion :pitch 500))))
;;		     ))

	      ;; Make `C-x C-m' and `C-x RET' be different (since I tend
	      ;; to type the latter by accident sometimes.)
	      (define-key global-map [(control x) return] nil)

	      ;; Change the cursor used when the mouse is over a mode line
	      ;;(setq x-mode-pointer-shape "leftbutton")

	      ;; Change the cursor used during garbage collection.
	      ;;
	      ;; Note that this cursor image is rather large as cursors go,
	      ;; and so it won't work on some X servers (such as the MIT
	      ;; R5 Sun server) because servers may have lamentably small
	      ;; upper limits on cursor size.
	      ;;(if (featurep 'xpm)
	      ;;   (setq x-gc-pointer-shape
	      ;;	 (expand-file-name "trash.xpm" data-directory)))

	      ;; Here's another way to do that: it first tries to load the
	      ;; cursor once and traps the error, just to see if it's
	      ;; possible to load that cursor on this system; if it is,
	      ;; then it sets x-gc-pointer-shape, because we knows that
	      ;; will work.  Otherwise, it doesn't change that variable
	      ;; because we know it will just cause some error messages.
	      (if (featurep 'xpm)
		  (let ((file (expand-file-name "recycle.xpm" data-directory)))
		    (if (condition-case error
			    (make-cursor file) ;returns a cursor if successful.
			  (error nil))	    ; returns nil if an error occurred.
			(setq x-gc-pointer-shape file))))
	 
	      ;; Add `dired' to the File menu
	      (add-menu-button '("File") [ "Edit Directory" dired t] "Exit XEmacs")

	      ;; Here's a way to add scrollbar-like buttons to the menubar
	      ;; (add-menu-item nil "Top" 'beginning-of-buffer t)
	      ;; (add-menu-item nil "PgDn" 'scroll-down t)
              ;; (add-menu-item nil "<<<" 'scroll-down t)
	      ;; (add-menu-item nil " . " 'recenter t)
              ;; (add-menu-item nil ">>>" 'scroll-up t)
	      ;; (add-menu-item nil "PgUp" 'scroll-up t)
	      ;; (add-menu-item nil "Bot" 'end-of-buffer t)

              ;; Return to the most recent buffer 
              ;; (add-menu-item nil "Next" '(switch-to-other-buffer 1) t)
	      ;;(add-menu-item nil "Next" 'cycle-buffer t)
	      ;;(add-menu-item nil "Back" 'switch-to-other-buffer t)
	      (add-menu-button '("Buffers") 
			       [ "Cycle to Next"  cycle-buffer-next t] 
			       "List All Buffers")

	      (add-menu-button '("Buffers") 
                                [ "Cycle to Prev" cycle-buffer-prev t]
                                "List All Buffers")

	      (add-menu-button '("Buffers")
			       [ "Most Recent"    switch-to-other-buffer t]
                                "List All Buffers")

;;	      (add-menu-button '("Buffers") '("singleDashedLine") )
	      
	      ;; Change the behavior of mouse button 2 (which is normally
	      ;; bound to `mouse-yank'), so that it inserts the selected text
	      ;; at point (where the text cursor is), instead of at the
	      ;; position clicked.
	      ;;
	      ;; Note that you can find out what a particular key sequence or
	      ;; mouse button does by using the "Describe Key..." option on
	      ;; the Help menu.
	      (setq mouse-yank-at-point t)

	      ;; When editing C code (and Lisp code and the like), I often
	      ;; like to insert tabs into comments and such.  It gets to be
	      ;; a pain to always have to use `C-q TAB', so I set up a more
	      ;; convenient binding.  Note that this does not work in
	      ;; TTY frames.
	      (define-key global-map '(shift tab) 'self-insert-command)

	      ;; LISPM bindings of Control-Shift-C and Control-Shift-E.
	      ;; Note that "\C-C" means Control-C, not Control-Shift-C.
	      ;; To specify shifted control characters, you must use the
	      ;; more verbose syntax used here.
	      (define-key emacs-lisp-mode-map '(control C) 'compile-defun)
	      (define-key emacs-lisp-mode-map '(control E) 'eval-defun)

	      ;; If you like the FSF Emacs binding of button3 (single-click
	      ;; extends the selection, double-click kills the selection),
	      ;; uncomment the following:

	      ;; Under 19.13, the following is enough:
              ;(define-key global-map 'button3 'mouse-track-adjust)

	      ;; But under 19.12, you need this:
              ;(define-key global-map 'button3
              ;    (lambda (event)
              ;      (interactive "e")
              ;      (let ((default-mouse-track-adjust t))
              ;        (mouse-track event))))

	      ;; Under both 19.12 and 19.13, you also need this:
              ;(add-hook 'mouse-track-click-hook
              ;          (lambda (event count)
              ;            (if (or (/= (event-button event) 3)
              ;                    (/= count 2))
              ;                nil ;; do the normal operation
              ;              (kill-region (point) (mark))
              ;              t ;; don't do the normal operations.
              ;              )))


	      ))

       ))

;;; Older versions of emacs did not have these variables
;;; (emacs-major-version and emacs-minor-version.)
;;; Let's define them if they're not around, since they make
;;; it much easier to conditionalize on the emacs version.

(if (and (not (boundp 'emacs-major-version))
	 (string-match "^[0-9]+" emacs-version))
    (setq emacs-major-version
	  (string-to-int (substring emacs-version
				    (match-beginning 0) (match-end 0)))))
(if (and (not (boundp 'emacs-minor-version))
	 (string-match "^[0-9]+\\.\\([0-9]+\\)" emacs-version))
    (setq emacs-minor-version
	  (string-to-int (substring emacs-version
				    (match-beginning 1) (match-end 1)))))

;;; Define a function to make it easier to check which version we're
;;; running.

(defun running-emacs-version-or-newer (major minor)
  (or (> emacs-major-version major)
      (and (= emacs-major-version major)
	   (>= emacs-minor-version minor))))

(cond ((and running-xemacs
	    (running-emacs-version-or-newer 19 6))
       ;;
       ;; Code requiring XEmacs/Lucid Emacs version 19.6 or newer goes here
       ;;
       ))

(cond ((>= emacs-major-version 19)
       ;;
       ;; Code for any vintage-19 emacs goes here
       ;;
       ))

(cond ((and (not running-xemacs)
	    (>= emacs-major-version 19))
       ;;
       ;; Code specific to FSF Emacs 19 (not XEmacs/Lucid Emacs) goes here
       ;;
       ))

(cond ((< emacs-major-version 19)
       ;;
       ;; Code specific to emacs 18 goes here
       ;;
       ))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;		Customization of Specific Packages		    ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; ********************
;;; Load ange-ftp, which uses the FTP protocol as a pseudo-filesystem.
;;; When this is loaded, the pathname syntax /user@host:/remote/path
;;; refers to files accessible through ftp.
;;;

;BEN, 20-3 change
;(require 'dired)
;(require 'ange-ftp)
;(setq ange-ftp-default-user "anonymous"   ; id to use for /host:/remote/path
;      ange-ftp-generate-anonymous-password t ; use $USER@`hostname`
;      ange-ftp-binary-file-name-regexp "."   ; always transfer in binary mode
;      )


;;; ********************
;;; Load the auto-save.el package, which lets you put all of your autosave
;;; files in one place, instead of scattering them around the file system.
;;;
;(require 'auto-save)
;(setq auto-save-directory (expand-file-name "/home/greear/autosaves/")
;      auto-save-directory-fallback auto-save-directory
;      auto-save-hash-p nil
;      ange-ftp-auto-save t
;      ange-ftp-auto-save-remotely nil
;      ;; now that we have auto-save-timeout, let's crank this up
;      ;; for better interactive response.
;      auto-save-interval 2000
;      )


;; This adds additional extensions which indicate files normally
;; handled by c++-mode.

(setq auto-mode-alist
      (append '(("\\.C$"    . c++-mode)
		("\\.cc$"   . c++-mode)
		("\\.ino$"  . c++-mode)
		("\\.pde$"  . c++-mode)
		("\\.cpp$"  . c++-mode)
		("\\.cxx$"  . c++-mode)
		("\\.hh$"   . c++-mode)
		("\\.c$"    . c-mode)
		("\\.h$"    . c++-mode)
		("\\.H$"    . c++-mode)
		("\\.hxx$"  . c++-mode)
		("\\.gawk$" . awk-mode)
		("\\.htm$"  . html-mode)
		("\\.php"   . html-mode)
		("\\.java$" . java-mode)
		("\\.s$"    . asm-mode)
		("\\.asm$"  . asm-mode)
	        ("makefile" . makefile-mode)
		("Makefile" . makefile-mode))
	      auto-mode-alist))

(defun linux-c-mode ()
  "C mode with adjusted defaults for use with the Linux kernel."
  (interactive)
  (c-mode)
  (c-set-style "K&R")
  (setq tab-width 8)
  (setq indent-tabs-mode t)
  (setq c-basic-offset 8))

(defun curl-c-mode ()
  "C mode with adjusted defaults for use with the curl project."
  (interactive)
  (c-mode)
  (c-set-style "K&R")
  (setq tab-width 8)
  (setq indent-tabs-mode nil)
  (setq c-basic-offset 2)
  ;(whitespace-write-file-hook)
  ;(setq whitespace-check-buffer-leading nil)
  ;(setq whitespace-check-buffer-indent nil)
  ;(setq whitespace-check-buffer-trailing-whitespace t)
  ;(add-hook 'local-write-file-hooks 'curl-code-cleanup-sv)
  ;(define-key c-mode-base-map "\M-m" 'curl-code-cleanup)
)

(defun qca-c-mode ()
  "C mode with adjusted defaults for use with the ath10k firmware."
  (interactive)
  (c-mode)
  (c-set-style "K&R")
  (setq tab-width 8)
  (setq indent-tabs-mode nil)
  (setq c-basic-offset 4)
)

(defun rfal-c-mode ()
  "C mode with adjusted defaults for use with the RFAL project."
  (interactive)
  (c-mode)
  (c-set-style "K&R")
  (setq tab-width 8)
  (setq indent-tabs-mode nil)
  (setq c-basic-offset 4)
)

(defconst curl-c-style
  '((c-basic-offset . 2)
    (c-comment-only-line-offset . 0)
    (c-hanging-braces-alist     . ((substatement-open before after)))
    (c-offsets-alist . ((topmost-intro        . 0)
			(topmost-intro-cont   . 0)
			(substatement         . +)
			(substatement-open    . 0)
			(statement-case-intro . +)
			(statement-case-open  . 0)
			(case-label           . 0)
			))
    )
  "Curl C Programming Style")


(setq auto-mode-alist (cons '("curl.*\\.[ch]$" . curl-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("c-ares.*\\.[ch]$" . curl-c-mode) auto-mode-alist))

(setq auto-mode-alist (cons '("kumo-rfal.*\\.[ch]$" . rfal-c-mode) auto-mode-alist))

(setq auto-mode-alist (cons '("perf_pwr_offload.*\\.[ch]$" . qca-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("ath10k_candela.*\\.[ch]$" . qca-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("qca-.*\\.[ch]$" . qca-c-mode) auto-mode-alist))

(setq auto-mode-alist (cons '("carl9170fw.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("linux.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("kernel-next.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("iproute2.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("net-next-2.6.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("net-2.6.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("wireless-2.6.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("madwifi.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("nfs-utils.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("hostap.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("iw/.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("libnl/.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("ethtool/.*\\.[ch]$" . linux-c-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("radvd.*\\.[ch]$" . linux-c-mode) auto-mode-alist))


(autoload 'python-mode "python-mode" "Python editing mode." t)
(add-to-list 'auto-mode-alist '("SConstruct" . python-mode))
(add-to-list 'auto-mode-alist '("SConscript" . python-mode))


(autoload 'c++-mode  "cc-mode" "C++ Editing Mode" t)
(autoload 'c-mode    "cc-mode" "C Editing Mode" t)
(autoload 'objc-mode "cc-mode" "Objective-C Editing Mode" t)

;;-----------------------------------------------------------------
;; JAVA Mode 
;;-----------------------------------------------------------------

;; This is a new one I downloaded off the web --Ben


;   (load "jde")
;   (setq jde-web-browser "BROWSER")
;   (setq jde-doc-dir "JDK DIRECTORY")
;   (jde-db-set-source-paths "SRCPTH1;SRCPTH2;...) 

;   (load "andersl-java-font-lock.el")
;
;   (load "jde")
;   (setq jde-web-browser "netscape")
;   (setq jde-doc-dir "/usr/local/jdk1.1.3/docs/")
;   (jde-db-set-source-paths "/home/greear/mud/Hegemon") 





;(require 'java-mode)
;(require 'java-flock)
;(require 'java-compile)

;(autoload 'java-mode "java-mode" "java mode" t nil)

;(add-hook 'java-mode-hook '(lambda () (java-font-lock-mode 'gaudy)))

;;-----------------------------------------------------------------
;; CC Mode 
;;-----------------------------------------------------------------
;;; cc-mode (the mode you're in when editing C, C++, and Objective C files)

;; Tell cc-mode not to check for old-style (K&R) function declarations.
;; This speeds up indenting a lot.
(setq c-recognize-knr-p nil)

;; Define a C/C++ style that is consistent with what I like and 
;; what the project standards are.

; BEN HEERE, un-comment this for auto newlines upon ; or {
; I personally don't like that so its commented out...
(defconst my-c-style
  '((c-basic-offset                . 3)
;    (c-tab-always-indent           . t)
;    (c-comment-only-line-offset    . 0)
;    (c-indent-comments-syntactically . t)
;    (c-hanging-braces-alist        . ((substatement-open before after)
;				      (brace-list-open)))
;    (c-hanging-colons-alist        . ((member-init-intro before)
;				      (inher-intro)
;				      (case-label after)
;				      (label after)
;				      (access-label after)))
;    (c-cleanup-list                . (scope-operator
;				      empty-defun-braces
;				      defun-close-semi))
;    (c-offsets-alist               . ((topmost-intro        . 0)
;				      (topmost-intro-cont   . 0)
;				      (substatement         . +)
;				      (substatement-open    . 0)
;				      (statement-case-intro . +)
;				      (case-label           . +)
;				      (access-label         . -)
;				      (inclass              . +)
;				      (inline-open          . +)
;                                      (arglist-close        . c-lineup-arglist) 
;				      (block-open           . 0)
;				      (knr-argdecl-intro    . -)))
;    (c-echo-syntactic-information-p . t)
    )
  "My C Programming Style")

;HEERE, end of the autoformatting extras
;; C++ Mode Popup Menu 
;; Add entries for local 'include', 'flip', and copyright operations
(defvar my-c-mode-menu
  '(["Locate Include File"       locate-include-file t]
    ["Flip to other file"        flip                t]
     "------"
    ["Insert Copyright Notice"   new-copyright       t]
    ["Create .h Template"        new-h-file          t]
     "------"
    ["Visit VPATH copy of file"  vpath-visit-reflection   t]
    ["Diff file with VPATH copy" vpath-file-diff          t]
     "------"
    ["Comment Out Region"     comment-region (mark)]
    ["Macro Expand Region"    c-macro-expand (mark)]
    ["Backslashify"           c-backslash-region (mark)]
    ["Indent Expression"      c-indent-exp
     (memq (following-char) '(?\( ?\[ ?\{))]
    ["Indent Line"            c-indent-command t]
    ["Indent Region"          indent-region    (mark)]
    ["Fill Comment Paragraph" c-fill-paragraph t]
    ["Up Conditional"         c-up-conditional t]
    ["Backward Conditional"   c-backward-conditional t]
    ["Forward Conditional"    c-forward-conditional t]
    ["Backward Statement"     c-beginning-of-statement t]
    ["Forward Statement"      c-end-of-statement t]
    )
  "XEmacs 19 (formerly Lucid) menu for C/C++/ObjC modes.")

;; Customizations for all of c-mode, c++-mode, and objc-mode
(defun my-c-mode-common-hook ()
  ;; add my personal style and set it for the current buffer
  (c-add-style "PERSONAL" my-c-style t)
  ;; offset customizations not in my-c-style
  (c-set-offset 'member-init-intro '++)
  ;; other customizations
  (setq tab-width 8
	;; this will make sure spaces are used instead of tabs
	indent-tabs-mode nil)
  ;; we like auto-newline and hungry-delete .. yum, yum 
  (c-toggle-hungry-state 1)
  ;(c-toggle-auto-hungry-state 1)
  ;; keybindings for C, C++, and Objective-C.  We can put these in
  ;; c-mode-map because c++-mode-map and objc-mode-map inherit it
  (define-key c-mode-map "\C-m" 'newline-and-indent)
  ;; use my popup menu
  (setq c-mode-menu my-c-mode-menu)
  )

;; the following only works in Emacs 19
;; Emacs 18ers can use (setq c-mode-common-hook 'my-c-mode-common-hook)
(add-hook 'c-mode-common-hook 'my-c-mode-common-hook)

;;;;----------------------------------------------------------------------
;;;;
;;;; ***     AWK Mode    *** 
;;;;

(defun my-awk-mode-hook ()
  ;; add my personal style and set it for the current buffer
  ;;(c-add-style "PERSONAL" my-c-style t)
  ;; offset customizations not in my-c-style
  ;;(c-set-offset 'member-init-intro '++)
  ;; other customizations
  (setq tab-width 8
	;; this will make sure spaces are used instead of tabs
	indent-tabs-mode nil)
  ;; we like auto-newline and hungry-delete .. yum, yum 
  ;;(c-toggle-auto-hungry-state 1)
  ;; we Do-Not like auto-newline and hungry-delete .. yum, yum 
  (c-toggle-auto-state  -1)  ;; no auto newline 
  (c-toggle-hungry-state 1)  ;; hungry delete 
  ;; keybindings for C, C++, and Objective-C.  We can put these in
  ;; c-mode-map because c++-mode-map and objc-mode-map inherit it
  ;;(define-key c-mode-map "\C-m" 'newline-and-indent)
  ;; use my popup menu
  ;; (setq c-mode-menu my-c-mode-menu)
  )

(add-hook 'awk-mode-hook 'my-c-mode-common-hook)



(setq auto-mode-alist
    (append
      '(("\\.asn$"     . snmp-mode)
        ("\\.mib$"     . snmp-mode)
        ("\\.smi$"     . snmp-mode)
        ("\\.as2$"     . snmpv2-mode)
        ("\\.mi2$"     . snmpv2-mode)
        ("\\.sm2$"     . snmpv2-mode))
      auto-mode-alist))

(autoload 'snmp-mode "snmp-mode" "Mode for editing SNMP MIBs" t)
(autoload 'snmpv2-mode "snmp-mode" "Mode for editing SNMPv2 MIBs" t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;  Modeline configuration 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(setq line-number-mode t)   ; Display line number in mode line 
;(display-column-mode())     ;displays line number and column number

;displays full path of file being edited or the dired name or the buffer name
(setq frame-title-format
  '("%S: " (buffer-file-name "%f" (dired-directory dired-directory "%b"))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Menubar Customization 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;an extensive menubar
;(load "big-menubar")

;;these lines disable the mail toolbar and mail pulldown menus
;(delete-menu-item ' ("Apps" "Read Mail (VM)...")) 
;(delete-menu-item ' ("Apps" "Read Mail (MH)...")) 
;(delete-menu-item ' ("Apps" "Send Mail...")) 
;;don't do below command, mail icon is removed from toolbar below in
;;    .emacs file
;(defconst toolbar-mail-command nil)

;;these lines delete the sparcworks debugger items
;(delete-menu-item ' ("SPARCworks" "News...")) 
;(delete-menu-item ' ("SPARCworks" "Enable Frame for SBrowser")) 
;(delete-menu-item ' ("SPARCworks" "Enable Frame for Debugger and Dbx")) 
;(delete-menu-item ' ("SPARCworks" "Start Tool and Enable Frame")) 

;these lines remove SPARCworks from the menu-bar
;(load "easymenu")
;(easy-menu-remove '("SPARCworks"))


(setq ispell-program-name "/usr/local/bin/ispell")
;(setq ispell-program-name "~madderoj/bin/ispell")
;(defconst ispell-dictionary "/usr/share/lib/dict/words")
;(defconst ispell-alternate-dictionary "/usr/share/lib/dict/words")


(defconst w3-use-netscape-configuration-file t)
(defconst ispell-check-comments t)

;load in hexidecimal commands
(load "hexl");

;load in horizontal scrolling
(load "hscroll")

;turn on horizontal scroll bars and define shift arrow to scroll by one
;(setq-default truncate-lines t)
;(hscroll-mode)
;(setq-default hscroll-mode t)
;(global-set-key 'f32 'mouse-scroll-left)
;(global-set-key 'f30 'mouse-scroll-right)
;(global-set-key 'f34 'mouse-scroll-up)
;(global-set-key 'f28 'mouse-scroll-down)

;(define-key global-map '(shift right) 'mouse-scroll-left)
;(define-key global-map '(shift left)  'mouse-scroll-right)
;(define-key global-map '(shift up)    'mouse-scroll-down)
;(define-key global-map '(shift down)  'mouse-scroll-up)

;(define-key global-map '(control right) 'mouse-scroll-left-full)
;(define-key global-map '(control left)  'mouse-scroll-right-full)
;(define-key global-map '(control up)    'mouse-scroll-down-full)
;(define-key global-map '(control down)  'mouse-scroll-up-full)


;;; ********************
;;; Load the 'recent-files' package 
;;; This package puts a "Recent Files" pulldown on the menubar
;;; It tracks the N most recently visited files.
;(require 'recent-files)
;(recent-files-initialize)
;(setq recent-files-number-of-entries 30)  ;; show 30 most recent files 


;;; ********************
;;; Load a partial-completion mechanism, which makes minibuffer completion
;;; search multiple words instead of just prefixes; for example, the command
;;; `M-x byte-compile-and-load-file RET' can be abbreviated as `M-x b-c-a RET'
;;; because there are no other commands whose first three words begin with
;;; the letters `b', `c', and `a' respectively.
;;;
;(load-library "completer")

;after typing 3 or more chars of a word, type f1 and emacs will try to complete
;the word based on other words in the buffer that begin with the same chars
;(global-set-key 'f1 'complete)

; use Z-Mail for mail 
;(defconst mail-command "zmail -gui -filter &") 

;;; ********************
;;; Load crypt, which is a package for automatically decoding and reencoding
;;; files by various methods - for example, you can visit a .Z or .gz file,
;;; edit it, and have it automatically re-compressed when you save it again.
;;; 
;(setq crypt-encryption-type 'pgp   ; default encryption mechanism
;      crypt-confirm-password t	   ; make sure new passwords are correct
      ;crypt-never-ever-decrypt t  ; if you don't encrypt anything, set this to
				   ; tell it not to assume that "binary" files
				   ; are encrypted and require a password.
;      )
;(require 'crypt)


;;; ********************
;;; Edebug is a source-level debugger for emacs-lisp programs.
;;;
;(define-key emacs-lisp-mode-map "\C-xx" 'edebug-defun)

;; *********************
;; Redefine the toolbar 

;(defvar toolbar-make-icon "visit-up.xbm" "visit-dn.xbm" "visit-xx.xbm")
;(defvar toolbar-make-icon 
;         "/user/m/madderoj/toolbar/make-cap-up.xpm"
;         "/user/m/madderoj/toolbar/make-cap-xx.xpm"
;         "/user/m/madderoj/toolbar/make-cap-xx.xpm")

;(defvar toolbar-new-icon-directory "/user/m/madderoj/toolbar/")
;
;(defvar toolbar-make-icon
;  (if (featurep 'xpm)
;      (toolbar-make-button-list
;       (expand-file-name "make-up.xpm" toolbar-new-icon-directory)
;       nil
;       (expand-file-name "make-xx.xpm" toolbar-new-icon-directory)
;       (expand-file-name "make-cap-up.xpm" toolbar-new-icon-directory)
;       nil
;       (expand-file-name "make-cap-xx.xpm" toolbar-new-icon-directory))
;    (toolbar-make-button-list
;     (expand-file-name "make-up.xbm" toolbar-new-icon-directory)
;     (expand-file-name "make-dn.xbm" toolbar-new-icon-directory)
;     (expand-file-name "make-xx.xbm" toolbar-new-icon-directory)))
;  "A make icon pair.")

(defconst  initial-toolbar-spec
  '([toolbar-file-icon		find-file	t	"Open a file"	]
    [toolbar-folder-icon	dired		t	"View directory"]
    [toolbar-disk-icon		save-buffer	t	"Save buffer"	]
    [toolbar-printer-icon	lpr-buffer	t	"Print buffer"	]
    [toolbar-cut-icon		x-kill-primary-selection t "Kill region"]
    [toolbar-copy-icon		x-copy-primary-selection t "Copy region"]
    [toolbar-paste-icon		x-yank-clipboard-selection t
				"Paste from clipboard"]
    [toolbar-undo-icon		undo		t	"Undo edit"	]
    [toolbar-spell-icon		toolbar-ispell	t	"Spellcheck"	]
    [toolbar-replace-icon	query-replace	t	"Replace text"	]
;    [toolbar-mail-icon		toolbar-mail	nil	"Mail"		]
    [toolbar-mail-icon		(shell-command mail-command)  	t	"ZMail"		]
    [toolbar-info-icon		toolbar-info	t	"Information"	]
;    [toolbar-compile-icon	toolbar-compile		t	"Compile"	]
    [toolbar-compile-icon	(compile compile-command)		t	"Compile"	]
;    [toolbar-make-icon	         (compile make-command)		t	"Make"	]
    [toolbar-debug-icon	        toolbar-debug	t	"Debug"		]
    [toolbar-news-icon		toolbar-news	t	"News"		])
  "The initial toolbar for a buffer.")

;(set-specifier default-toolbar initial-toolbar-spec)


;initiates desktop saving.  Do this once in a directory and the desktop will be
;saved and automatically resaved when exiting emacs.  When emacs is started in that
;directory all files that were in the buffer from the last time are re-loaded.
;You only need to do this ONCE the rest is automatic.
;;(define-key global-map 'f3 'desktop-save)

;reads desktop if there is one for the directory.  If so then load buffers from saved
;desktop.  Keep these next commands near the bottom of .emacs file.
;;(load "desktop")
;;(desktop-load-default)
;;(desktop-read)

;;; ********************
;;; Font-Lock is a syntax-highlighting package.  When it is enabled and you
;;; are editing a program, different parts of your program will appear in
;;; different fonts or colors.  For example, with the code below, comments
;;; appear in red italics, function names in function definitions appear in
;;; blue bold, etc.  The code below will cause font-lock to automatically be
;;; enabled when you edit C, C++, Emacs-Lisp, and many other kinds of
;;; programs.
;;;
;;; The "Options" menu has some commands for controlling this as well.
;;;
;BEN
(cond (running-xemacs

       ;; If you want the default colors, you could do this:
       ;; (setq font-lock-use-default-fonts nil)
       ;; (setq font-lock-use-default-colors t)
       ;; but I want to specify my own colors, so I turn off all
       ;; default values.
       (setq font-lock-use-default-fonts nil)
       (setq font-lock-use-default-colors nil)

       (require 'font-lock)

       ;; Mess around with the faces a bit.  Note that you have
       ;; to change the font-lock-use-default-* variables *before*
       ;; loading font-lock, and wait till *after* loading font-lock
       ;; to customize the faces.

       ;; string face is green
       (set-face-foreground 'font-lock-string-face "forest green")

       ;; comments are italic and red; doc strings are italic
       ;;
       ;; (I use copy-face instead of make-face-italic/make-face-bold
       ;; because the startup code does intelligent things to the
       ;; 'italic and 'bold faces to ensure that they are different
       ;; from the default face.  For example, if the default face
       ;; is bold, then the 'bold face will be unbold.)
       (copy-face 'italic 'font-lock-comment-face)
       ;; Underling comments looks terrible on tty's
       (set-face-underline-p 'font-lock-comment-face nil 'global 'tty)
       (set-face-highlight-p 'font-lock-comment-face t 'global 'tty)
       (copy-face 'font-lock-comment-face 'font-lock-doc-string-face)
       (set-face-foreground 'font-lock-comment-face "red")

       ;; function names are bold and blue
       (copy-face 'bold 'font-lock-function-name-face)
       (set-face-foreground 'font-lock-function-name-face "blue")

       ;; misc. face
       (and (find-face 'font-lock-preprocessor-face) ; 19.13 and above
            (copy-face 'bold 'font-lock-preprocessor-face))
       (copy-face 'italic 'font-lock-type-face)
       (copy-face 'bold   'font-lock-keyword-face)

       (set-face-foreground  'font-lock-comment-face       "tomato2")
       (set-face-foreground  'font-lock-keyword-face       "dodger blue")
       (set-face-foreground  'font-lock-type-face          "blue")
       (set-face-foreground  'font-lock-function-name-face "forest green")
       (set-face-foreground  'font-lock-preprocessor-face  "purple")
       (set-face-foreground  'font-lock-string-face        "sandy brown")
       (set-face-foreground  'font-lock-doc-string-face    "goldenrod")

       (make-face-unitalic   'font-lock-string-face)
       (make-face-unitalic   'font-lock-function-name-face)
       (make-face-unitalic   'font-lock-comment-face)
       (make-face-unitalic   'font-lock-type-face)
       (make-face-unitalic   'font-lock-keyword-face)

       (set-face-underline-p 'font-lock-string-face        nil)

       ;; (make-face-unbold     'font-lock-keyword-face)

       (add-hook 'emacs-lisp-mode-hook	'turn-on-font-lock)
       (add-hook 'lisp-mode-hook	'turn-on-font-lock)
       (add-hook 'c-mode-hook		'turn-on-font-lock)
       (add-hook 'c++-mode-hook		'turn-on-font-lock)
       (add-hook 'tex-mode-hook		'turn-on-font-lock)
       (add-hook 'texinfo-mode-hook	'turn-on-font-lock)
       (add-hook 'postscript-mode-hook	'turn-on-font-lock)
       (add-hook 'dired-mode-hook	'turn-on-font-lock)
       (add-hook 'ada-mode-hook		'turn-on-font-lock)
       (add-hook 'awk-mode-hook		'turn-on-font-lock)

       (setq c-font-lock-keywords     c-font-lock-keywords-2)        
       (setq c++-font-lock-keywords   c++-font-lock-keywords-2)  
       (setq lisp-font-lock-keywords  lisp-font-lock-keywords-2)
;;       (setq dired-font-lock-keywords dired-font-lock-keywords-2)
        
       ))

(add-to-list 'auto-mode-alist '("\\.\\([pP]\\([Llm]\\|[oO][dD]\\)\\|al
+\\)\\'" . cperl-mode))
(add-to-list 'interpreter-mode-alist '("perl" . cperl-mode))
(add-to-list 'interpreter-mode-alist '("perl5" . cperl-mode))
(add-to-list 'interpreter-mode-alist '("miniperl" . cperl-mode))

;; Use cperl-mode instead of the default perl-mode
(defalias 'perl-mode 'cperl-mode)

;; just spaces
(setq-default indent-tabs-mode nil)

;; Use 3 space indents via cperl mode
(custom-set-variables
  '(cperl-close-paren-offset -3)
  '(cperl-continued-statement-offset 3)
  '(cperl-indent-level 3)
  '(cperl-indent-parens-as-block t)
  '(cperl-tab-always-indent t)
)



;;; ********************
;;; fast-lock is a package which speeds up the highlighting of files
;;; by saving information about a font-locked buffer to a file and
;;; loading that information when the file is loaded again.  This
;;; requires a little extra disk space be used.
;;;
;;; Normally fast-lock puts the cache file (the filename appended with
;;; .flc) in the same directory as the file it caches.  You can
;;; specify an alternate directory to use by setting the variable
;;; fast-lock-cache-directories.

;; Let's use lazy-lock instead.
;;(add-hook 'font-lock-mode-hook 'turn-on-fast-lock)
;;(setq fast-lock-cache-directories '("/foo/bar/baz"))


;;; ********************
;;; lazy-lock is a package which speeds up the highlighting of files
;;; by doing it "on-the-fly" -- only the visible portion of the
;;; buffer is fontified.  The results may not always be quite as
;;; accurate as using full font-lock or fast-lock, but it's *much*
;;; faster.  No more annoying pauses when you load files.

;;(add-hook 'font-lock-mode-hook 'turn-on-lazy-lock)
;; I personally don't like "stealth mode" (where lazy-lock starts
;; fontifying in the background if you're idle for 30 seconds)
;; because it takes too long to wake up again on my piddly Sparc 1+.
;;(setq lazy-lock-stealth-time nil)


;;; ********************
;;; func-menu is a package that scans your source file for function
;;; definitions and makes a menubar entry that lets you jump to any
;;; particular function definition by selecting it from the menu.  The
;;; following code turns this on for all of the recognized languages.
;;; Scanning the buffer takes some time, but not much.
;;;
;;; Send bug reports, enhancements etc to:
;;; David Hughes <ukchugd@ukpmr.cs.philips.nl>
;;;
(cond (running-xemacs
       (require 'func-menu)
       (define-key global-map 'f8 'function-menu)
       (add-hook 'find-file-hooks 'fume-add-menubar-entry)
       (define-key global-map "\C-cl" 'fume-list-functions)
       (define-key global-map "\C-cg" 'fume-prompt-function-goto)

       ;; The Hyperbole information manager package uses (shift button2) and
       ;; (shift button3) to provide context-sensitive mouse keys.  If you
       ;; use this next binding, it will conflict with Hyperbole's setup.
       ;; Choose another mouse key if you use Hyperbole.
       (define-key global-map '(shift button3) 'mouse-function-menu)

       ;; For descriptions of the following user-customizable variables,
       ;; type C-h v <variable>
       (setq fume-max-items 100
             fume-fn-window-position 3
             fume-auto-position-popup t
             fume-display-in-modeline-p t
             fume-menubar-menu-location "File"
             fume-buffer-name "*Function List*"
             fume-no-prompt-on-valid-default nil)
       ))


;;; ********************
;;; MH is a mail-reading system from the Rand Corporation that relies on a
;;; number of external filter programs (which do not come with emacs.)
;;; Emacs provides a nice front-end onto MH, called "mh-e".
;;;
;; Bindings that let you send or read mail using MH
;(global-set-key "\C-xm" 'mh-smail)
;(global-set-key "\C-x4m" 'mh-smail-other-window)
;(global-set-key "\C-cr" 'mh-rmail)

;; Customization of MH behavior.
(setq mh-delete-yanked-msg-window t)
(setq mh-yank-from-start-of-msg 'body)
(setq mh-summary-height 11)

;; Use lines like the following if your version of MH
;; is in a special place.
;(setq mh-progs "/usr/dist/pkgs/mh/bin.svr4/")
;(setq mh-lib "/usr/dist/pkgs/mh/lib.svr4/")


;;; ********************
;;; resize-minibuffer-mode makes the minibuffer automatically
;;; resize as necessary when it's too big to hold its contents.

;(autoload 'resize-minibuffer-mode "rsz-minibuf" nil t)
;(resize-minibuffer-mode)
;(setq resize-minibuffer-window-exactly nil)

 
;;; ********************
;;; W3 is a browser for the World Wide Web, and takes advantage of the very
;;; latest redisplay features in XEmacs.  You can access it simply by typing 
;;; 'M-x w3'; however, if you're unlucky enough to be on a machine that is 
;;; behind a firewall, you will have to do something like this first:

;(setq w3-use-telnet t
;      ;;
;      ;; If the Telnet program you use to access the outside world is
;      ;; not called "telnet", specify its name like this.
;      w3-telnet-prog "itelnet"
;      ;;
;      ;; If your Telnet program adds lines of junk at the beginning
;      ;; of the session, specify the number of lines here.
;      w3-telnet-header-length 4
;      )
;; Experiment 
;; ProtoGen Mode 

;; ------------------------------------------------------------------
;; ProtoGen Mode 

;; This adds additional extensions which indicate files normally
;; handled by c++-mode.

(setq auto-mode-alist
      (append '(("\\.pro$" . protogen-mode))
	      auto-mode-alist))

(autoload 'protogen-mode  "protogen-mode" "ProtoGen Specification Editing Mode" t)

;(setq protogen-mode-hook
;    (function (lambda ()
;         (font-lock-mode 1)             ;; font-lock the buffer
;         (setq protogen-indent 8)
;	 (setq protogen-group-offset -8))
;	 (setq protogen-brace-offset -8)   
;         (setq protogen-tab-always-indent t)
;         (setq protogen-match-and-tell t)
;         (setq protogen-align-to-keyword t)	;; Turn on keyword alignment
;	 )))

(add-hook 'protogen-mode-hook	'turn-on-font-lock)

;; ------------------------------------------------------------------
;; SCL (Simulation Command Language) Mode 

(setq auto-mode-alist
      (append '(("\\.scl$" . scl-mode))
	      auto-mode-alist))

(autoload 'scl-mode  "scl-mode" "SCL (Sim Cmd) Editing Mode" t)

;(setq protogen-mode-hook
;    (function (lambda ()
;         (font-lock-mode 1)             ;; font-lock the buffer
;         (setq protogen-indent 8)
;	 (setq protogen-group-offset -8))
;	 (setq protogen-brace-offset -8)   
;         (setq protogen-tab-always-indent t)
;         (setq protogen-match-and-tell t)
;         (setq protogen-align-to-keyword t)	;; Turn on keyword alignment
;	 )))

(add-hook 'scl-mode-hook 'turn-on-font-lock)

;; End Experiment 


;; Options Menu Settings
;; =====================
(cond ((and running-xemacs
	    (running-emacs-version-or-newer 19 12))
       ;;
       ;; Code requiring XEmacs/Lucid Emacs version 19.12 or newer goes here
       ;;
  (setq-default overwrite-mode nil)
  (setq-default teach-extended-commands-p t)
  (setq-default bar-cursor 2)
  (setq-default debug-on-error nil)
  (setq-default debug-on-quit nil)
  (setq-default get-frame-for-buffer-default-instance-limit nil)
  (setq-default temp-buffer-show-function 'show-temp-buffer-in-current-frame)
  (setq-default complex-buffers-menu-p t)
  (setq-default font-menu-ignore-scaled-fonts t)
  (setq-default font-menu-this-frame-only-p t)
  (setq-default buffers-menu-max-size nil)
  (setq-default case-fold-search t)
  (setq-default case-replace t)
  (setq-default zmacs-regions t)
  (setq-default truncate-lines nil)
  (setq-default mouse-yank-at-point nil)
  (set-default-toolbar-position 'left)
  (add-spec-list-to-specifier top-toolbar-height '((global (nil . 0))))
  (add-spec-list-to-specifier bottom-toolbar-height '((global (nil . 0))))
  (add-spec-list-to-specifier left-toolbar-width '((global (nil . 37))))
  (add-spec-list-to-specifier right-toolbar-width '((global (nil . 0))))
  (add-spec-list-to-specifier scrollbar-width 'nil)
  (add-spec-list-to-specifier scrollbar-height 'nil)
  (add-spec-list-to-specifier modeline-shadow-thickness '((global (nil . 2))))
  (require 'paren)
  (paren-set-mode 'sexp)
  (require 'pending-del)
  (setq-default font-lock-auto-fontify t)
  (setq-default font-lock-use-fonts  nil)
  (setq-default font-lock-use-colors t)

;; Trying to make fontifying take less time. --Ben
  (setq-default font-lock-use-maximum-decoration 2)
  (setq-default font-lock-use-maximal-decoration nil) ;; Was 't', --Ben

  (setq-default font-lock-mode-enable-list nil)
  (setq-default font-lock-mode-disable-list nil)
  (require 'font-lock)
  (require 'fast-lock)
  (add-hook 'font-lock-mode-hook 'turn-on-fast-lock)

  ;;-------------------------------------------------------------------
  ;; Font Lock Faces
  ;;-------------------------------------------------------------------
  
;  (make-face 'font-lock-keyword-face)
;  (add-spec-list-to-specifier (face-property 'font-lock-keyword-face 'foreground) '((global (nil . "medium orchid"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-keyword-face 'background) '((global (nil . "papaya whip"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-keyword-face 'font) '((global (nil . "-*-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-*"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-keyword-face 'underline) '((global ((tty)))))
;  (add-spec-list-to-specifier (face-property 'font-lock-keyword-face 'highlight) '((global ((tty) . t))))

;  (make-face 'font-lock-type-face)
;  (add-spec-list-to-specifier (face-property 'font-lock-type-face 'foreground) '((global (nil . "blue"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-type-face 'background) '((global (nil . "papaya whip"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-type-face 'font) '((global (nil . "-*-courier-medium-r-*-*-*-120-*-*-*-*-iso8859-*"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-type-face 'underline) '((global ((tty)))))

;  (make-face 'font-lock-comment-face)
;  (add-spec-list-to-specifier (face-property 'font-lock-comment-face 'foreground) '((global (nil . "tomato2"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-comment-face 'background) '((global (nil . "papaya whip"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-comment-face 'font) '((global (nil . "-*-courier-medium-r-*-*-*-120-*-*-*-*-iso8859-*"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-comment-face 'underline) '((global ((tty)))))
;  (add-spec-list-to-specifier (face-property 'font-lock-comment-face 'highlight) '((global ((tty) . t))))

;  (make-face 'font-lock-preprocessor-face)
;  (add-spec-list-to-specifier (face-property 'font-lock-preprocessor-face 'foreground) '((global (nil . "purple"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-preprocessor-face 'background) '((global (nil . "papaya whip"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-preprocessor-face 'font) '((global (nil . "-*-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-*"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-preprocessor-face 'highlight) '((global ((tty) . t))))

;  (make-face 'font-lock-doc-string-face)
;  (add-spec-list-to-specifier (face-property 'font-lock-doc-string-face 'foreground) '((global (nil . "goldenrod"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-doc-string-face 'background) '((global (nil . "papaya whip"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-doc-string-face 'font) '((global (nil . "-*-courier-medium-i-*-*-*-120-*-*-*-*-iso8859-*"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-doc-string-face 'underline) '((global ((tty)))))
;  (add-spec-list-to-specifier (face-property 'font-lock-doc-string-face 'highlight) '((global ((tty) . t))))

;  (make-face 'font-lock-string-face)
;  (add-spec-list-to-specifier (face-property 'font-lock-string-face 'foreground) '((global (nil . "goldenrod"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-string-face 'background) '((global (nil . "papaya whip"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-string-face 'font) '((global (nil . "-*-courier-medium-r-*-*-*-120-*-*-*-*-iso8859-*"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-string-face 'underline) '((global ((tty)) (nil))))
;  (add-spec-list-to-specifier (face-property 'font-lock-string-face 'highlight) '((global ((tty) . t))))

;  (make-face 'font-lock-function-name-face)
;  (add-spec-list-to-specifier (face-property 'font-lock-function-name-face 'foreground) '((global (nil . "forest green"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-function-name-face 'background) '((global (nil . "papaya whip"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-function-name-face 'font) '((global (nil . "-*-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-*"))))
;  (add-spec-list-to-specifier (face-property 'font-lock-function-name-face 'underline) '((global ((tty)))))
;  (add-spec-list-to-specifier (face-property 'font-lock-function-name-face 'highlight) '((global ((tty) . t))))

  ;;-------------------------------------------------------------------
  ;; Paren faces 
  ;;-------------------------------------------------------------------
  
  (make-face 'paren-match)
  (add-spec-list-to-specifier (face-property 'paren-match 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'paren-match 'background) '((global ((color) . "darkseagreen2") ((color) . "green") ((grayscale) . "gray1") (nil . "darkseagreen2"))))
  (add-spec-list-to-specifier (face-property 'paren-match 'background-pixmap) '((global ((color x) . [nothing]) ((color tty) . [nothing]) ((color stream) . [nothing]) ((grayscale x) . [nothing]) ((grayscale tty) . [nothing]) ((grayscale stream) . [nothing



]) ((mono x) . [string :data "gray1"]) ((mono tty) . [string :data "gray1"]))))
  (add-spec-list-to-specifier (face-property 'paren-match 'highlight) '((global ((tty) . t))))

  (make-face 'paren-mismatch)
  (add-spec-list-to-specifier (face-property 'paren-mismatch 'foreground) '((global ((grayscale x) . [modeline foreground]) ((mono x) . [modeline foreground]) (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'paren-mismatch 'background) '((global ((grayscale x) . [modeline background]) ((mono x) . [modeline background]) ((color x) . "DeepPink") (nil . "DeepPink"))))
  (add-spec-list-to-specifier (face-property 'paren-mismatch 'reverse) '((global ((tty) . t))))

  (make-face 'paren-blink-off)
  (add-spec-list-to-specifier (face-property 'paren-blink-off 'foreground) '((global (nil . "WhiteSmoke"))))
  (add-spec-list-to-specifier (face-property 'paren-blink-off 'background) '((global (nil . "papaya whip"))))

  ;;-------------------------------------------------------------------
  ;; ISearch faces 
  ;;-------------------------------------------------------------------
  
  (make-face 'isearch)
  (add-spec-list-to-specifier (face-property 'isearch 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'isearch 'background) '((global ((color) . "paleturquoise") ((color) . "green") (nil . "paleturquoise"))))
  (add-spec-list-to-specifier (face-property 'isearch 'reverse) '((global ((tty) . t))))

  ;;-------------------------------------------------------------------
  ;; Source Browser faces 
  ;;-------------------------------------------------------------------
  
  (make-face 'sbrowse-arrow-face)
  (add-spec-list-to-specifier (face-property 'sbrowse-arrow-face 'foreground) '((global (nil . "blue"))))
  (add-spec-list-to-specifier (face-property 'sbrowse-arrow-face 'background) '((global (nil . "WhiteSmoke"))))

  
  (make-face 'hollow-arrow-face)
  (add-spec-list-to-specifier (face-property 'hollow-arrow-face 'foreground) '((global (nil . "purple"))))
  (add-spec-list-to-specifier (face-property 'hollow-arrow-face 'background) '((global (nil . "WhiteSmoke"))))

  (make-face 'solid-arrow-face)
  (add-spec-list-to-specifier (face-property 'solid-arrow-face 'foreground) '((global (nil . "purple"))))
  (add-spec-list-to-specifier (face-property 'solid-arrow-face 'background) '((global (nil . "WhiteSmoke"))))

  (make-face 'stop-face)
  (add-spec-list-to-specifier (face-property 'stop-face 'foreground) '((global (nil . "red"))))
  (add-spec-list-to-specifier (face-property 'stop-face 'background) '((global (nil . "WhiteSmoke"))))


  (make-face 'section-heading)
  (add-spec-list-to-specifier (face-property 'section-heading 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'section-heading 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'section-heading 'font) '((global (nil . "-adobe-courier-bold-r-normal--*-130-0-0-m-0-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'section-heading 'highlight) '((global ((tty) . t))))

  (make-face 'left-margin)
  (add-spec-list-to-specifier (face-property 'left-margin 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'left-margin 'background) '((global (nil . "papaya whip"))))

  (make-face 'major-heading)
  (add-spec-list-to-specifier (face-property 'major-heading 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'major-heading 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'major-heading 'font) '((global (nil . "-adobe-courier-bold-r-normal--*-140-0-0-m-0-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'major-heading 'highlight) '((global ((tty) . t))))

  (make-face 'primary-selection)
  (add-spec-list-to-specifier (face-property 'primary-selection 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'primary-selection 'background) '((global ((grayscale) . "gray3") ((color) . "gray") (nil . "gray"))))
  (add-spec-list-to-specifier (face-property 'primary-selection 'background-pixmap) '((global ((mono x) . [string :data "gray3"]) ((mono tty) . [string :data "gray3"]))))

  (make-face 'secondary-selection)
  (add-spec-list-to-specifier (face-property 'secondary-selection 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'secondary-selection 'background) '((global ((grayscale) . "gray1") ((color) . "paleturquoise") ((color) . "green") (nil . "paleturquoise"))))
  (add-spec-list-to-specifier (face-property 'secondary-selection 'background-pixmap) '((global ((mono x) . [string :data "gray1"]) ((mono tty) . [string :data "gray1"]))))

  (make-face 'warning)
  (add-spec-list-to-specifier (face-property 'warning 'foreground) '((global (nil . "red"))))
  (add-spec-list-to-specifier (face-property 'warning 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'warning 'font) '((global (nil . "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'warning 'highlight) '((global ((tty) . t))))


  ;;-------------------------------------------------------------------
  ;; Info faces 
  ;;-------------------------------------------------------------------
  
  (make-face 'info-node)
  (add-spec-list-to-specifier (face-property 'info-node 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'info-node 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'info-node 'font) '((global (nil . "-adobe-courier-bold-i-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'info-node 'underline) '((global ((tty) . t))))
  (add-spec-list-to-specifier (face-property 'info-node 'highlight) '((global ((tty) . t))))

  (make-face 'info-xref)
  (add-spec-list-to-specifier (face-property 'info-xref 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'info-xref 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'info-xref 'font) '((global (nil . "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'info-xref 'highlight) '((global ((tty) . t))))

  ;;-------------------------------------------------------------------
  ;; Generic faces 
  ;;-------------------------------------------------------------------
  
  (make-face 'bold)
  (add-spec-list-to-specifier (face-property 'bold 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'bold 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'bold 'font) '((global (nil . "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'bold 'highlight) '((global ((tty) . t))))

  (make-face 'bold-italic)
  (add-spec-list-to-specifier (face-property 'bold-italic 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'bold-italic 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'bold-italic 'font) '((global (nil . "-adobe-courier-bold-i-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'bold-italic 'underline) '((global ((tty) . t))))
  (add-spec-list-to-specifier (face-property 'bold-italic 'highlight) '((global ((tty) . t))))

  (make-face 'highlight)
  (add-spec-list-to-specifier (face-property 'highlight 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'highlight 'background) '((global ((color) . "darkseagreen2") ((color) . "green") ((grayscale) . "gray1") (nil . "darkseagreen2"))))
  (add-spec-list-to-specifier (face-property 'highlight 'background-pixmap) '((global ((color x) . [nothing]) ((color tty) . [nothing]) ((color stream) . [nothing]) ((grayscale x) . [nothing]) ((grayscale tty) . [nothing]) ((grayscale stream) . [nothing])



 ((mono x) . [string :data "gray1"]) ((mono tty) . [string :data "gray1"]))))
  (add-spec-list-to-specifier (face-property 'highlight 'highlight) '((global ((tty) . t))))

  (make-face 'underline)
  (add-spec-list-to-specifier (face-property 'underline 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'underline 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'underline 'underline) '((global (nil . t))))

  (make-face 'heading)
  (add-spec-list-to-specifier (face-property 'heading 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'heading 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'heading 'font) '((global (nil . "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'heading 'highlight) '((global ((tty) . t))))

  (make-face 'hyperlink)
  (add-spec-list-to-specifier (face-property 'hyperlink 'foreground) '((global (nil . "blue"))))
  (add-spec-list-to-specifier (face-property 'hyperlink 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'hyperlink 'font) '((global (nil . "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'hyperlink 'highlight) '((global ((tty) . t))))

  (make-face 'right-margin)
  (add-spec-list-to-specifier (face-property 'right-margin 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'right-margin 'background) '((global (nil . "papaya whip"))))

  (make-face 'modeline)
  (add-spec-list-to-specifier (face-property 'modeline 'foreground) '((global (nil . "Black"))))
  (add-spec-list-to-specifier (face-property 'modeline 'background) '((global (nil . "Gray75"))))
  (add-spec-list-to-specifier (face-property 'modeline 'background-pixmap) '((global ((x) . [nothing]) ((tty) . [nothing]) ((stream) . [nothing]))))
  (add-spec-list-to-specifier (face-property 'modeline 'reverse) '((global ((tty) . t))))

  (make-face 'standout)
  (add-spec-list-to-specifier (face-property 'standout 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'standout 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'standout 'font) '((global (nil . "-adobe-courier-medium-i-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'standout 'underline) '((global ((tty) . t))))

  (make-face 'documentation)
  (add-spec-list-to-specifier (face-property 'documentation 'foreground) '((global (nil . "firebrick"))))
  (add-spec-list-to-specifier (face-property 'documentation 'background) '((global (nil . "papaya whip"))))

  (make-face 'zmacs-region)
  (add-spec-list-to-specifier (face-property 'zmacs-region 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'zmacs-region 'background) '((global ((grayscale) . "gray3") ((color) . "gray") (nil . "gray"))))
  (add-spec-list-to-specifier (face-property 'zmacs-region 'background-pixmap) '((global ((mono x) . [string :data "gray3"]) ((mono tty) . [string :data "gray3"]) ((grayscale x) . [nothing]) ((grayscale tty) . [nothing]) ((grayscale stream) . [nothing]) (



(color x) . [nothing]) ((color tty) . [nothing]) ((color stream) . [nothing]))))
  (add-spec-list-to-specifier (face-property 'zmacs-region 'reverse) '((global ((tty) . t))))

  (make-face 'italic)
  (add-spec-list-to-specifier (face-property 'italic 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'italic 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'italic 'font) '((global (nil . "-adobe-courier-medium-i-*-*-*-120-*-*-*-*-iso8859-1"))))
  (add-spec-list-to-specifier (face-property 'italic 'underline) '((global ((tty) . t))))

  (make-face 'default)
  (add-spec-list-to-specifier (face-property 'default 'foreground) '((global (nil . "black"))))
  (add-spec-list-to-specifier (face-property 'default 'background) '((global (nil . "papaya whip"))))
  (add-spec-list-to-specifier (face-property 'default 'font) '((global (nil . "-*-Courier-Medium-R-*-*-*-120-0-0-*-*-iso8859-1"))))

  ))

;BEN, 20-3 changes
;(cond ((and running-xemacs
;	    (running-emacs-version-or-newer 20 0))
;       ;;
;       ;; Code requiring XEmacs/Lucid Emacs version 19.12 or newer goes here
;       ;;
;       (require 'dired-xemacs-highlight)
;       ))
;; ============================
;; End of Options Menu Settings





(setq minibuffer-max-depth nil)
