;; cycle.el 
;;
;;;
;; cycle around buffers 
;;
;; Treat buffer "stack" as a ring. 
;;
;; The 'next' buffer is the deserving buffer at the bottom of the 
;; buffer stack. 
;;
;; The 'prev' buffer is the buffer just under the current buffer 
;; in the buffer stack. 
;;
;;  

(defun cycle-buffer-next ()
   (interactive)
   (switch-to-buffer (cycle-locate-next-buffer)))

(defun cycle-buffer-prev ()
   (interactive)
   (switch-to-other-buffer 0))

;; Locate the 'next' buffer.  
(defun cycle-locate-next-buffer () 
  "Return the name of the \"next\" buffer. The next buffer is the 
first buffer off the bottom of the buffer stack whose name does not 
start with a space character. (Names that begin with spaces are used
for internal emacs buffers). Returns 'nil' if no suitable buffer is 
available."
  (let ((buflist (reverse (buffer-list)))
	(retval nil)
	(matched nil))
    (while (and buflist
		(not matched))
      (if (string-match "^[^ ]" (buffer-name (car buflist)))
	  (progn
	    (setq matched t)
	    (setq retval (buffer-name (car buflist))))
      (setq buflist (cdr buflist))))
    retval))


(provide 'cycle-buffer)

;(defun x-show ()
;   (interactive)
;   (with-output-to-temp-buffer "*cycle*"
;      (princ (length (buffer-list)))
;      (princ "\n")
;
;      (princ (buffer-list))
;      (princ "\n")
;
;      (princ "First Buffer is '")
;      (princ (car (buffer-list)))
;      (princ "'")
;      (terpri)
;      (princ "Buffer is '")
;      (princ (cycle-locate-next-buffer))
;      (princ "'")
;      (terpri)))

