; em-project.el 
;
; Emacs customization for the Element Manager Project 
;
;

;---------------------------------------------------------------
;
; EM project is using all <> style brackets for the 
; #include statements and passing -I. to the compiler 
; to pick up files in the current directory first.
;
; Also, EM project is using the VPATH options during make
; that specify alternate source directories. The CPP include 
; dirs list reflects the search order for the VPATH directories 
; as well. 
;
;---------------------------------------------------------------

(require 'include)
(require 'vpath)

(setq vpath-development-dir (getenv "EM_DEVPATH"))
(setq vpath-release-dir     (getenv "EM_RLSEPATH"))

(setq my-include-dirs 
  (list
    (concat (getenv "EM_DEVPATH") "/include_public/")
    (concat (getenv "EM_RLSEPATH") "/include_public/")

    (concat (getenv "EM_DEVPATH") "/include_private/")
    (concat (getenv "EM_RLSEPATH") "/include_private/")

    ;; (concat (getenv "ATIUM_DV_HOME") "/include_public/")
    ;; (concat (getenv "ATIUM_DV_HOME") "/include_private/")

     '"/opt/OV/include/"
     '"/opt/SUNWspro/SC3.0/include/CC/"))

(setq my-cpp-include-dirs 
   (list 
     '"/usr/include/"))

;; Ediff customization 

(require 'ediff)
(setq ediff-split-window-function 'split-window-horizontally)


(global-set-key '(control kp_enter)    'vpath-flip)
(global-set-key '(shift   kp_enter)    'vpath-include)

(global-set-key '(control kp_divide)   'vpath-visit-reflection)
(global-set-key '(shift   kp_divide)   'vpath-file-diff)

;;
;; Apparently the kp_divide, kp_multiply keys use keyboard macros 
;; rather than direct function calls ... 
;;
;; I would prefer to us the Keypad Divide key to activate the 
;; vpath operations .. but the global-set-key defines them 
;; as keyboard-macros ... so if they fail and call (beep) the 
;; keyboard macro fails and any error text output by the functions 
;; is overwritten by the error message emitted by the kbd macro 
;; processor ..

(global-set-key '(control f9)    'vpath-visit-reflection)
(global-set-key '(control f10)   'vpath-file-diff)

;; load the file creation template routines:
;;
;;   new-h-file - creates .h file template
;;   new-c-file - creates .c file template 
;;   new-copyright - inserts a copyright 
;;

(load "file-template")

;;;(modeline-click-swaps-buffers t)