; emacs-flip.el 
;
; find the "other" file corresponding to the .c or .h extenstion 
;
; ----------------------------------------------------------------
; 
; What this does today:
;
;  If the flip file exists, visit it 
;  If the file does not exist, prompt for creation (Guess at extension)
;
; ----------------------------------------------------------------
;
; Added an "includer' facility. When the cursor is on a C/C++ #include 
; line invoking locate-include-file will visit the included file.
;  
; ----------------------------------------------------------------
; Nice to have: 
;
;  Show a completion buffer that lists all applicable extensions
;
;   e.g., for x.C  show  x.h x.H x.hh etc .. 
;
; The yes-or-no-p function is nice for prompting for create 
; but I don't like having to type y-e-s to create the file. 
; Also the filename is part of the prompt and cannot be edited. 
;
; The read-file-name function looks promising 
; 
; ----------------------------------------------------------------

;
; Need to add VPATH support for this .. 
;
;    For each entry in the flip list 
;      if the extension matches 
;        look for file in each dir of search path 
;
;

;
; The order of elements in this list is important. Files are flipped 
; on the first match. Be sure that a flip from .X to .Y and back results
; in the original .X buffer.
;
;; List should be changed so that flip can occur from left side
;; to right side or vice versa .. 
;; 
;; 
;; from recent-files.el 
;;; `recent-files-filename-replacements'
;;;    This is a list of pairs of regular expressions and replacement
;;;    strings. If a filename matches one of the regular expressions,
;;;    the matching part is replaced by the replacement string.
;;;    
;;;    Example: My home directory is "/users/mmc/nickel/". I want to
;;;    replace it with "~/". I also want to replace the directory
;;;    "/imports/teleservices/mmc/avc2/", where I work a lot, with
;;;    ".../avc2/". The list then looks like
;;;        (setq recent-files-filename-replacements
;;;              '(("/users/mmc/nickel/" . "~/")
;;;                ("/imports/teleservices/mmc/avc2/" . ".../avc2/")))
;;;    Only the first match is replaced. So, if you have several
;;;    entries in this list that may match a filename simultaneously,
;;;    put the one you want to match (usually the most special) in
;;;    front of the others. The default is to replace the home
;;;    directory with "~".
;;;


(defvar flip-filename-replacements
  (list (cons (expand-file-name "~") "~"))
  "*List of regexp/replacement pairs for filename filenamees.
If a filename of a filename matches one of the regexps, it is replaced
by the corresponding replacement.")

(setq flip-filename-replacements
      '(
	("\\.c$"   . ".h")
	("\\.C$"   . ".H")
	("\\.C$"   . ".h")
	("\\.cc$"  . ".h")
	("\\.cc$"  . ".hh")
	("\\.cc$"  . ".H")
	("\\.cpp$" . ".h")
	("\\.cpp$" . ".hpp")
	("\\.cxx$" . ".h")
	("\\.cxx$" . ".hxx")
	("\\.h$"   . ".C")
	("\\.h$"   . ".c")
	("\\.h$"   . ".cc")
	("\\.h$"   . ".cpp")
	("\\.h$"   . ".cxx")
	("\\.hh$"  . ".cc")
	("\\.hpp$" . ".cpp")
	("\\.hxx$" . ".cxx")
	("\\.H$"   . ".C")
	))

(defun flip ()
  "\"flip\" to the \"other\" file associated with the current buffer.
The \"other\" file name is constructed by replacing the extenstion of
the current buffer with an associated extension as defined in 
'flip-filenmae-replacements'. A typical example would be to flip from 
a .C file to a .H file and vice-versa. If the flip file does not exist
then prompt for confirmation to create it. "
   (interactive)
   (flip-to-partner buffer-file-name
		    (list (file-name-directory buffer-file-name))))

;(defun flip-old ()
;  "\"flip\" to the \"other\" file associated with the current buffer.
;The \"other\" file name is constructed by replacing the extenstion of
;the current buffer with an associated extension as defined in 
;'flip-filenmae-replacements'. A typical example would be to flip from 
;a .C file to a .H file and vice-versa. If the flip file does not exist
;then prompt for confirmation to create it. "
;  (interactive)
;  (if buffer-file-name
;      (let ((fn (find-flip-file-name buffer-file-name)))
;	(if fn
;	    (find-file fn)
;	  (let ((fn (create-flip-file-name buffer-file-name)))
;	    (if fn
;		(find-file (read-file-name 
;			    "(Flipper) File file not found: Create: "
;			    fn  ; (file-name-directory fn)    ; directory 
;			    fn  ; (file-name-nondirectory fn) ; default
;			    nil ; 10 ; require confirmation .. 
;			    ))
;	;	    (if (yes-or-no-p (concat "Create " fn " ? " ))
;	;		(find-file fn))
;	      (progn
;		(beep)
;		(message "(Flipper) No flip file")
;		nil))))
;	nil)
;    (beep)
;    (message "(Flipper) No flip file" )))
;

(defun flip-to-partner (filename pathname)
  "\"flip\" to the \"other\" file associated with the current buffer.
The \"other\" file name is constructed by replacing the extenstion of
the current buffer with an associated extension as defined in 
'flip-filenmae-replacements'. A typical example would be to flip from 
a .C file to a .H file and vice-versa. If the flip file does not exist
then prompt for confirmation to create it. "
;;  (interactive)
  (if filename
      (let ((fn (find-flip-file-name-in-path 
		 (file-name-nondirectory filename) pathname)))
	(if fn
	    (find-file fn)
	  (let ((fn (create-flip-file-name-in-path 
		     filename pathname)))
	    (if fn
		(find-file (read-file-name 
			    "(Flipper) File file not found: Create: "
			    fn  ; (file-name-directory fn)    ; directory 
			    fn  ; (file-name-nondirectory fn) ; default
			    nil ; 10 ; require confirmation .. 
			    ))
	;	    (if (yes-or-no-p (concat "Create " fn " ? " ))
	;		(find-file fn))
	      (progn
		(beep)
		(message "(Flipper) No flip file")
		nil))))
	nil)
    (beep)
    (message "(Flipper) No flip file" )))

;(defun find-flip-file-name (filename)
;  "Replace the part of FILENAME that matches a regular expression
;in 'flip-filename-replacements' with the corrensponding replacement.
;If FILENAME does not match any regular expression, or if no files
;named by preforming replacements are found, return nil.
;All matching regexp/replacement pairs are applied until either a matching
;file exists or the list is exhausted."
;  (find-flip-file-name-in-path filename (file-name-directory filename)))

;(defun find-flip-file-name-old (filename)
;  "Replace the part of FILENAME that matches a regular expression
;in 'flip-filename-replacements' with the corrensponding replacement.
;If FILENAME does not match any regular expression, or if no files
;named by preforming replacements are found, return nil.
;All matching regexp/replacement pairs are applied until either a matching
;file exists or the list is exhausted."
;  (let ((replist flip-filename-replacements)
;	(retval nil)
;	(matched nil))
;    (while (and replist
;		(not matched))
;      (if (string-match (car (car replist)) filename)
;	  (let ((fn (concat (substring filename 0 (match-beginning 0))
;				 (cdr (car replist))
;				 (substring filename (match-end 0)))))
;	    (if (or (get-file-buffer fn)
;		    (file-readable-p fn))
;		(progn
;		   (setq matched t)
;		   (setq retval fn)))))
;      (setq replist (cdr replist)))
;    retval))

;(defun create-flip-file-name (filename)
;  "Replace the part of FILENAME that matches a regular expression
;in flip-filename-replacements with the corrensponding replacement.
;If FILENAME does not match any regular expression, return nil.
;Only the first matching regexp/replacement pair is applied."
;  (let ((replist flip-filename-replacements)
;	(retval nil)
;	(matched nil))
;    (while (and replist
;		(not matched))
;      (if (string-match (car (car replist)) filename)
;	  (progn
;	    (setq matched t)
;	    (setq retval (concat (substring filename 0 (match-beginning 0))
;				 (cdr (car replist))
;				 (substring filename (match-end 0))))))
;      (setq replist (cdr replist)))
;    retval))
;


(defun find-flip-file-name-in-path (filename pathlist)
  "Replace the part of FILENAME that matches a regular expression
in 'flip-filename-replacements' with the corrensponding replacement.
Search each of the replacements in each path in the pathlist.
If FILENAME does not match any regular expression, or if no files
named by preforming replacements are found, return nil.
All matching regexp/replacement pairs are applied until either a matching
file exists or the list is exhausted."
  (let ((replist flip-filename-replacements)
	(retval nil)
	(matched nil))

;(with-output-to-temp-buffer "*flip trace*"
;(princ "find-flip-filename:\n")
;(princ "   filename=")
;(princ filename)
;(princ "\n")
;(princ "  paths=")
;(princ pathlist)
;(princ "\n")

    (while (and replist
		(not matched))
      (if (string-match (car (car replist)) filename)
	  (let ((fn (concat (substring filename 0 (match-beginning 0))
				 (cdr (car replist))
				 (substring filename (match-end 0)))))

;(princ "regex match:")
;(princ (car replist))
;(princ "\n")
;(princ "fn=")
;(princ fn)
;(princ "\n")

	    (if (or (get-file-buffer fn)
                    (setq fn (search-for-file 
			      (file-name-nondirectory fn) pathlist)))
;		    (locate-file fn pathlist))
		(progn
		   (setq matched t)
		   (setq retval fn)))))
      (setq replist (cdr replist)))
;)
    retval))

(defun create-flip-file-name-in-path (filename pathlist)
  "Replace the part of FILENAME that matches a regular expression
in flip-filename-replacements with the corrensponding replacement.
If FILENAME does not match any regular expression, return nil.
Only the first matching regexp/replacement pair is applied."
  (let ((replist flip-filename-replacements)
	(retval nil)
	(matched nil))
    (while (and replist
		(not matched))
      (if (string-match (car (car replist)) filename)
	  (progn
	    (setq matched t)
	    (setq retval 

;;
;; why doesn't this work ?? 
;; the filename comes out relative ~/xyz 
;;

		  ;(concat (car pathlist)
			;  (file-name-nondirectory
			   (concat (substring filename 0 (match-beginning 0))
				 (cdr (car replist))
				 (substring filename (match-end 0)))));))
      (setq replist (cdr replist))))
    retval))

;;

(provide 'flip)
