;;;
;;; web mode, for editing noweb
;;; By Bruce Stephens <bruce@liverpool.ac.uk>, March 1994
;;; Comes with no warranty, etc., consult the standard FSF statement
;;; for details.

(defvar web-tex-mode-map nil)
(defvar web-c++-mode-map nil)
(defvar web-c++-mode-character nil)
(defvar web-tex-mode-indent nil)
(defvar web-c++-mode-indent nil)

(defun noweb-mode ()
  "WEB mode, for editing noweb files"
  (interactive)
  (LaTeX-mode)
  (setq web-tex-mode-map (current-local-map)
	web-tex-mode-indent indent-line-function)
  (c++-mode)
  (setq web-c++-mode-map (current-local-map)
	web-c++-mode-indent indent-line-function)
  (define-key web-tex-mode-map "\t" 'web-tex-indent)
  (define-key web-c++-mode-map "\t" 'web-c++-indent)
  (put 'web-c++-mode-character 'local-map web-c++-mode-map)
  (web-overlay-keymap)
  (use-local-map web-tex-mode-map))
  
(defun web-tex-indent ()
  (interactive)
  (funcall web-tex-mode-indent))l

(defun web-c++-indent ()
  (interactive)
  (funcall web-c++-mode-indent))

(defun web-find-next-region (start end)
  "Finds the region beginning with regexp START, and ending with regexp END,
returning the position at the beginning of START end just before END"
  (let (first last)
    (setq first (search-forward-regexp start nil t))
    (cond (first (setq first (match-beginning 0))
		 (setq last (search-forward-regexp end nil t))
		 (cond (last (cons first last))
		       (t (cons first (point-max)))))
	  (t nil))))

(defun web-overlay-keymap ()
  "Overlay the c++-mode keymap on the relevant bits of the buffer"
  (interactive)
  (save-excursion
    (remove-text-properties (point-min)
			    (point-max)
			    (list 'local-map nil))
    (goto-char (point-min))
    (let (region)
      (while (setq region (web-find-next-region
			   "^<<.*>>=" "^\\@"))
	(add-text-properties (car region)
			     (cdr region)
			     '(category web-c++-mode-character))
	(goto-char (cdr region))))))
