;; file-template.el
;;
;; gven a file extension, create a 'template' for the new file
;;
;; This is mpst helpful when creating .H files for the first time
;;
;; This would be better implemented as a table lookup based on 
;; file extension. 
;;
;;

(defun new-h-file ()
"Create a template for a new .h (include file).
Createes a small comment showing the filename and writes the 
#include sandwich constructs."
   (interactive)
   (let ((fn (file-name-nondirectory buffer-file-name))
	 (marker nil))
       (setq marker (replace-in-string (upcase fn) "[^a-zA-Z]" "_"))
       (beginning-of-line)
       (insert "// " fn) (newline)
       (insert "// ")    (newline)
       (new-copyright)
       (newline)
       (insert "#ifndef _" marker "_") (newline)
       (insert "#define _" marker "_") (newline)
       (newline)
       (insert "#endif // _" marker "_") (newline)))


(defun new-c-file ()
"Create a template for a new .c (source file)"
   (interactive)
   (let ((fn (file-name-nondirectory buffer-file-name)))
       (beginning-of-line)
       (insert "// " fn) (newline)
       (insert "// ")    (newline)
       (new-copyright)
       (newline)
       (insert "#include \"" fn ".h\"") (newline)
       (newline)))


(defconst new-copyright-notice
(list
"-----------------------------------------------------------------------"
"This software and the information therein is the proprietary and"
"confidential property of AG Communication Systems Corporation and is"
"provided with the understanding that it shall not be copied or"
"reproduced in whole or in part or disclosed to others without the"
"prior written permission of AG Communication Systems Corporation."
"Such software and information is to be used only for the purpose for"
"which it has been supplied."
"-"
"Copyright (c) AG Communication Systems Corporation 1996"
"-"
"-----------------------------------------------------------------------"
))

(defun new-copyright ()
"Insert a software copyright."
   (interactive)
   (let ((opoint (point)))
     (newline)
     (let ((text new-copyright-notice))
       (while text
	 (insert (car text)) 
	 (newline)
	 (setq text (cdr text)))
     (comment-region opoint (point))
)))
