
;; Hacks from cc-mode.el to reslove undefineds  (Bill Davies)


;; there is probably a way to just assign the map directly .. ? 

;(defvar java-mode-map ()
;  "Keymap used in java-mode buffers.")
;(if java-mode-map
;    ()
;  ;; TBD: should we even worry about naming this keymap. My vote: no,
;  ;; because FSF and XEmacs (formerly Lucid) do it differently.
;  (setq java-mode-map (make-sparse-keymap))
;  ;; put standard keybindings into MAP
;  ;; the following mappings correspond more or less directly to BOCM
;  (define-key java-mode-map "{"         'c-electric-brace)
;  (define-key java-mode-map "}"         'c-electric-brace)
;  (define-key java-mode-map ";"         'c-electric-semi&comma)
;  (define-key java-mode-map "#"         'c-electric-pound)
;  (define-key java-mode-map ":"         'c-electric-colon)
;  ;; Lemacs 19.9 defines these two, the second of which is commented out
;  ;; (define-key java-mode-map "\e{" 'c-insert-braces)
;  ;; Commented out electric square brackets because nobody likes them.
;  ;; (define-key java-mode-map "[" 'c-insert-brackets)
;  (define-key java-mode-map "\e\C-h"    'c-mark-function)
;  (define-key java-mode-map "\e\C-q"    'c-indent-exp)
;  (define-key java-mode-map "\ea"       'c-beginning-of-statement)
;  (define-key java-mode-map "\ee"       'c-end-of-statement)
;  ;; I'd rather use an adaptive fill program instead of this.
;  (define-key java-mode-map "\eq"       'c-fill-paragraph)
;  (define-key java-mode-map "\C-c\C-n"  'c-forward-conditional)
;  (define-key java-mode-map "\C-c\C-p"  'c-backward-conditional)
;  (define-key java-mode-map "\C-c\C-u"  'c-up-conditional)
;  (define-key java-mode-map "\t"        'c-indent-command)
;  (define-key java-mode-map "\177"      'c-electric-delete)
;  ;; these are new keybindings, with no counterpart to BOCM
;  (define-key java-mode-map ","         'c-electric-semi&comma)
;  (define-key java-mode-map "/"         'c-electric-slash)
;  (define-key java-mode-map "*"         'c-electric-star)
;  (define-key java-mode-map "\C-c\C-q"  'c-indent-defun)
;  (define-key java-mode-map "\C-c\C-\\" 'c-backslash-region)
;  ;; TBD: where if anywhere, to put c-backward|forward-into-nomenclature
;  (define-key java-mode-map "\C-c\C-a"  'c-toggle-auto-state)
;  (define-key java-mode-map "\C-c\C-b"  'c-submit-bug-report)
;  (define-key java-mode-map "\C-c\C-c"  'comment-region)
;  (define-key java-mode-map "\C-c\C-d"  'c-toggle-hungry-state)
;  (define-key java-mode-map "\C-c\C-e"  'c-macro-expand)
;  (define-key java-mode-map "\C-c\C-o"  'c-set-offset)
;  (define-key java-mode-map "\C-c\C-s"  'c-show-syntactic-information)
;  (define-key java-mode-map "\C-c\C-t"  'c-toggle-auto-hungry-state)
;  ;; conflicts with OOBR
;  ;;(define-key java-mode-map "\C-c\C-v"  'c-version)
;  ;; FSF Emacs 19 defines menus in the mode map. This call will return
;  ;; t on FSF Emacs 19, otherwise no-op and return nil.
;  (if (and (not (c-mode-fsf-menu "C" java-mode-map))
;	   ;; in XEmacs (formerly Lucid) 19, we want the menu to popup
;	   ;; when the 3rd button is hit.  In 19.10 and beyond this is
;	   ;; done automatically if we put the menu on mode-popup-menu
;	   ;; variable, see c-common-init. RMS decided that this
;	   ;; feature should not be included for FSF's Emacs.
;	   (boundp 'current-menubar)
;	   (not (boundp 'mode-popup-menu)))
;      (define-key java-mode-map 'button3 'c-popup-menu)))


(defvar java-compile-command nil)
(defvar java-shell-args nil)
(defvar java-command nil)
(defvar java-compile-history nil)
(require 'compile)

;;;


(add-hook 'java-mode-hook 'java-menu)

(defun java-menu ()
  (progn
;;        (define-key java-mode-map [menu-bar compile]
;;        (cons "Compile" (make-sparse-keymap "Compile")))

      (define-key java-mode-map "\em" 'compile)
      (define-key java-mode-map "\ec" 'java-compile)
      (define-key java-mode-map "\er" 'java-run)


;;    (define-key java-mode-map "\em" 'compile)
;;    (define-key java-mode-map [menu-bar compile make]
;;        '("Make Project" . compile))

;;    (define-key java-mode-map "\ec" 'java-compile)
;;    (define-key java-mode-map [menu-bar compile java-compile]
;;        '("Compile" . java-compile))

;;    (define-key java-mode-map "\er" 'java-run)
;;    (define-key java-mode-map [menu-bar compile java-run]
;;        '("Run" . java-run))
    ))

(defun java-compile ()
  "Compile Java program in current buffer"
  (interactive)
  (let ((compile-command (concat "javac " buffer-file-name)))
    (setq java-compile-command (read-from-minibuffer "Compile command: "
                                 compile-command nil nil
                                 '(java-compile-history . 1))))

  (compile java-compile-command)
)

(defun java-run ()
  "Run Java program, using current buffer for name of class to run"
  (interactive)
  (let (file-name-length
	stem
	file-name
	class-file-name
	;compile-buffer
        )
    (progn
      ;; strip .java from name - shuld check it is there!
      (setq file-name-length (- (length buffer-file-name) 5))
      (setq stem (substring buffer-file-name 0 file-name-length))
      (setq file-name (file-name-nondirectory stem))

      ;; this won't work if a package with '.' fields is executed!
      (setq java-shell-args (concat "java " file-name))

      ;; make sure class file is up-to-date
      (save-some-buffers)
      (setq class-file-name (concat file-name ".class"))
      (if (file-newer-than-file-p buffer-file-name class-file-name)
	  (let ((compile-buffer (java-compile)))
	    ;; we need to compile the file before running java
	     (let ((proc (get-buffer-process compile-buffer)))
	       (set-process-sentinel proc 'java-compile-sentinel)))
	(progn
	  (set (java-explicit-shell-args) (java-run-command))
	  ;;no compile needed, just run java
	  ;;the value of explicit-<shell>-args is used as
	  ;;the command to be run by the shell
	  (switch-to-buffer-other-window "*shell*")
	  (erase-buffer)
	  (shell))))))

(defun java-explicit-shell-args ()
  "returns the symbol explicit-<shell>-args where <shell>
is the name of the current shell e.g. returns
'explicit-bash-args if your favoured shell is bash"
  (let* ((full-shell (or (getenv "ESHELL")
		       (getenv "SHELL")
		       "sh"))
	 (shell (file-name-nondirectory full-shell)))
    (intern (concat "explicit-" (concat shell "-args")))))

(defun java-run-command ()
  "return the java run command for the shell to execute"
  (let ((args java-shell-args))
    (setq java-command (read-from-minibuffer "Run command: "
                                 args nil nil
                                 '(java-run-history . 1))))
    (cons "-c" (cons java-command ())))

(defun java-shell-sentinel (proc msg)
   "sentinel for java run completion"
   (switch-to-buffer (other-buffer)))

;; sentinel called when compilation is finished
(defun java-compile-sentinel (proc msg)
  "Sentinel for compilation buffers."
   (if (memq (process-status proc) '(signal exit))
     (progn
     (set-buffer (compilation-find-buffer))
      (goto-char (point-min))
      (let ((errors (compile-error-at-point)))
	   (if errors
	       (message "has errors")
	     (progn
	       (set (java-explicit-shell-args) (java-run-command))
	       (switch-to-buffer-other-window "*shell*")
	       (erase-buffer)
	       (shell)))))))



(provide 'java-compile)







