;; MPCM interface for Emacs 
;;
;; copied from /usr/local/lib/xemacs-19.13/lisp/packages/generic-sc.el 
;;
;; The RCS functions may have some interesting approaches too. 
;;

(defun sc-set-MPCM-mode ()
  (setq sc-generic-name "MPCM")
  (setq sc-can-hack-dir t)
  (setq sc-generic-lock-info   'mpcm-lock-info)
  (setq sc-generic-register    'mpcm-register)
  (setq sc-generic-check-out   'mpcm-check-out)
  (setq sc-generic-get-version 'mpcm-get-version)
  (setq sc-generic-check-in    'mpcm-check-in)
  (setq sc-generic-history     'mpcm-history)
  (setq sc-generic-tree-list   'mpcm-tree-list)
  (setq sc-generic-new-revision-p 'mpcm-new-revision-p)
  (setq sc-generic-revert      'mpcm-revert)
  (setq sc-generic-rename      'mpcm-rename)
  (setq sc-menu
	(cons (car sc-default-menu)
	      (cons ["Insert Headers"	mpcm-insert-headers	t]
		    (cdr sc-default-menu))))
  (define-key sc-prefix-map "h"    'mpcm-insert-headers)
  (define-key sc-prefix-map "\C-d" 'sc-update-directory))

;; Find a reasonable default for the MPCM bin directory
(defvar mpcm-bin-directory
  (cond ;((file-executable-p  "/usr/mpcm/unget") "/usr/mpcm")
	;((file-executable-p  "/usr/bin/unget")  "/usr/bin")
	;((file-directory-p   "/usr/mpcm")       "/usr/mpcm")
	;((file-directory-p   "/usr/bin/mpcm")   "/usr/bin/mpcm")
	(t "/projects/mpcm/bin/6.0/sun"))
  "*Directory where to find the mpcm executables")

(defvar mpcm-headers-wanted '("\%\W\%")
  "*MPCM header keywords to be inserted when mpcm-insert-header is executed.")

(defvar mpcm-insert-static t
  "*Insert a static character string when inserting source control headers in C mode.
Only relevant for the MPCM mode.")

;; Vars the user doesn't need to know about.

(defvar mpcm-log-entry-mode nil)
(defvar mpcm-current-major-version nil)

;; Some helper functions

(defun mpcm-name (file &optional letter)
  "Return the mpcm-file name corresponding to a given file."
  (if (null file)
      ()
    (file-name-nondirectory file)))

(defun mpcm-lock-info (file)
  "Lock-info method for MPCM.  See sc-generic-lock-info"
  (let ((mpcm-file (mpcm-name file))
	(lock-file (mpcm-name file)))
    (cond ((or (null file) (not (file-exists-p mpcm-file)))
	   ())
	  ((not (file-exists-p lock-file))
	   (list () ()))
	  (t
	   (save-excursion
	     (set-buffer (get-buffer-create "*MPCM tmp*"))
	     (insert-file lock-file)
	     (while (search-forward " " () t)
	       (replace-match "\n" () t))
	     (goto-char (point-min))
	     (forward-line 1)
	     (let ((revision
		    (buffer-substring (point) (progn (end-of-line) (point))))
		   (name
		    (progn (forward-line 1)
			   (buffer-substring (point)
					     (progn (end-of-line) (point))))))
	       (kill-buffer (current-buffer))
	       (list name revision)))))))


(defun mpcm-do-command (buffer command file &rest flags)
  "Execute an MPCM command, notifying the user and checking for errors."
  (let ((exec-path (cons mpcm-bin-directory exec-path)))
    (apply 'sc-do-command buffer command command file (mpcm-name file) flags)))

(defun mpcm-admin (file sid)
  "Checks a file into mpcm.
FILE is the unmodified name of the file.  SID should be the base-level sid to
check it in under."
  ;; give a change to save the file if it's modified
  (if (and (buffer-modified-p)
	   (y-or-n-p (format "%s has been modified. Write it out? "
			     (buffer-name))))
      (save-buffer))
  (mpcm-do-command "*MPCM*" "echo mpromote" file
		   (concat "-e" file) (concat "-r" sid))
  ;;;;(sc-chmod "-w" file)
  ;; expand MPCM headers
  (mpcm-check-out file nil))

(defun mpcm-register (file revision)
  (mpcm-load-vars)
;  ;(if (and (not (file-exists-p "MPCM"))
;	   (y-or-n-p "Directory MPCM does not exist, create it?"))
;      (make-directory "MPCM"))
  (mpcm-admin file
	      (cond 
	       (revision revision)
	       ((error-occurred (load-file "MPCM/emacs-vars.el")) "1")
	       (t mpcm-current-major-version))))

(defun mpcm-check-out (file lockp)
  "Retrieve a copy of the latest version of the given file."
  (mpcm-do-command "*MPCM*" "mfetch" file (if lockp "-e")))

;
; gets a temp version fpor editing .. 
;no analogue in MPCM ... 
; could copy file to temp, get file, rename 
(defun mpcm-get-version (file buffer revision)
  (mpcm-do-command buffer "get" file
		   (and revision (concat "-r" revision))
		   "-p" "-s"))

(defun mpcm-check-in (file revision comment)
  "Check-in a given version of the given file with the given comment."
  (mpcm-do-command "*MPCM*" "mpromote" file "-n"
		   (format "-r%s" revision)
		   (format "-y%s" comment))
  (sc-chmod "-w" file)
  ;; mpcm-delta already turned off write-privileges on the
  ;; file, let's not re-fetch it unless there's something
  ;; in it that get would expand
  (save-excursion
    (let ((buffer (get-file-buffer file)))
      (if buffer
	  (progn
	    (set-buffer buffer)
	    (mpcm-check-out file nil))))))

(defun mpcm-history (file)
  (mpcm-do-command (current-buffer) "prs" file))

;; There has *got* to be a better way to do this...
;
;(defun mpcm-save-vars (sid)
;  (save-excursion
;    (find-file "MPCM/emacs-vars.el")
;    (erase-buffer)
;    (insert "(setq mpcm-current-major-version \"" sid "\")")
;    (basic-save-buffer)))
;
;(defun mpcm-load-vars ()
;  (if (error-occurred (load-file "MPCM/emacs-vars.el"))
;      (setq mpcm-current-major-version "1")))
;
;; MPCM header insertion code

(defun mpcm-insert-headers ()
  "*Insert headers for use with the Source Code Control System.
Headers desired are inserted at the start of the buffer, and are pulled from 
the variable mpcm-headers-wanted"
  (interactive)
  (save-excursion
    (save-restriction
      (widen)
      (if (or (not (mpcm-check-headers))
	      (y-or-n-p "MPCM headers already exist.  Insert another set?"))
	  (progn
	     (goto-char (point-min))
	     (run-hooks 'mpcm-insert-headers-hook)

;; Add C++-mode 
;; add Makefile-mode 

	     (cond ((eq major-mode 'c-mode) (mpcm-insert-c-header))
		   ((eq major-mode 'c++-mode) (mpcm-insert-c++-header))
		   ((eq major-mode 'makefile-mode) (mpcm-insert-makefile-header))
		   ((eq major-mode 'lisp-mode) (mpcm-insert-lisp-header))
		   ((eq major-mode 'emacs-lisp-mode) (mpcm-insert-lisp-header))
		   ((eq major-mode 'scheme-mode) (mpcm-insert-lisp-header))
		   ((eq major-mode 'nroff-mode) (mpcm-insert-nroff-header))
		   ((eq major-mode 'plain-tex-mode) (mpcm-insert-tex-header))
		   ((eq major-mode 'texinfo-mode) (mpcm-insert-texinfo-header))
		   (t (mpcm-insert-generic-header))))))))



(defun mpcm-insert-c-header ()
  (let (st en)
    (insert "/*\n")
    (mapcar '(lambda (s)
	       (insert " *\t" s "\n"))
	    mpcm-headers-wanted)
    (insert " */\n\n")
    (if (and mpcm-insert-static 
	     (not (string-match "\\.h$" buffer-file-name)))
	(progn
	  (insert "#ifndef lint\n"
		  "static char *mpcmid")
;;	  (setq st (point))
;;	  (insert (file-name-nondirectory buffer-file-name))
;;	  (setq en (point))
;;	  (subst-char-in-region st en ?. ?_)
	  (insert " = \"\%\W\%\";\n"
		  "#endif /* lint */\n\n")))
    (run-hooks 'mpcm-insert-c-header-hook)))

(defun mpcm-insert-c++-header ()
  (mapcar '(lambda (s) 
		  (insert "// " s "\n"))
	  mpcm-headers-wanted)
  (insert "\n")
  (run-hooks 'mpcm-insert-c++-header-hook))

(defun mpcm-insert-makefile-header ()
  (mapcar '(lambda (s) 
		  (insert "# " s "\n"))
	  mpcm-headers-wanted)
  (insert "\n")
  (run-hooks 'mpcm-insert-makefile-header-hook))

(defun mpcm-insert-lisp-header ()
  (mapcar '(lambda (s) 
		  (insert ";;;\t" s "\n"))
	  mpcm-headers-wanted)
  (insert "\n")
  (run-hooks 'mpcm-insert-lisp-header-hook))

(defun mpcm-insert-nroff-header ()
  (mapcar '(lambda (s) 
		  (insert ".\\\"\t" s "\n"))
	  mpcm-headers-wanted)
  (insert "\n")
  (run-hooks 'mpcm-insert-nroff-header-hook))

(defun mpcm-insert-tex-header ()
  (mapcar '(lambda (s) 
		  (insert "%%\t" s "\n"))
	  mpcm-headers-wanted)
  (insert "\n")
  (run-hooks 'mpcm-insert-tex-header-hook))

(defun mpcm-insert-texinfo-header ()
  (mapcar '(lambda (s) 
		  (insert "@comment\t" s "\n"))
	  mpcm-headers-wanted)
  (insert "\n")
  (run-hooks 'mpcm-insert-texinfo-header-hook))

(defun mpcm-insert-generic-header ()
  (let* ((comment-start-mpcm (or comment-start "#"))
	 (comment-end-mpcm (or comment-end ""))
	 (dont-insert-nl-p (string-match "\n" comment-end-mpcm)))
    (mapcar '(lambda (s)
	       (insert comment-start-mpcm "\t" s ""
		       comment-end-mpcm (if dont-insert-nl-p "" "\n")))
	  mpcm-headers-wanted)
  (insert comment-start-mpcm comment-end-mpcm (if dont-insert-nl-p "" "\n"))))

(defun mpcm-check-headers ()
  "Check if the current file has any MPCM headers in it."
  (save-excursion
    (goto-char (point-min))
    (let ((case-fold-search ()))
      (re-search-forward  "%[MIRLBSDHTEGUYFPQCZWA]%" (point-max) t))))

(defun mpcm-tree-list ()
  "List all the registered files in the current directory"
  (call-process "/bin/sh" () t () "-c"
		(concat "/bin/ls -1 " default-directory "MPCM/s.*"))
  (goto-char (point-min))
  (while (search-forward "MPCM/s." () t)
    (replace-match "" () t)))

(defun mpcm-new-revision-p (file)
  "True if the MPCM archive is more recent than the file itself"
  (file-newer-than-file-p (mpcm-name file) file))

;; do mfetch -u for Unfetch 
(defun mpcm-revert (file)
  "Cancel a check-out and get a fresh copy of the file"
  (delete-file (mpcm-name file "p"))
  (delete-file file)
  (mpcm-do-command "*MPCM*" "get" file "-s"))

;
; would have to Obsolete and Add 
;

(defun mpcm-rename (old new)
  "Rename the MPCM archives for OLD to NEW"
  (if (file-exists-p (mpcm-name old "p"))
      (rename-file (mpcm-name old "p") (mpcm-name new "p") t))
  (if (file-exists-p (mpcm-name old "s"))
      (rename-file (mpcm-name old "s") (mpcm-name new "s") t)))

;(defun mpcm-obsolete (file)
;   (mpcm-do-command "*MPCM*" "admin - function" file flags)
;)

;(define mpcm-add (file)
;   (mpcm-do-command "*MPCM*" "madd" file flags)
;)