;; vpath.el 
;;
;; Emacs customization to handle development enviroments 
;; using the VPATHing. 
;;
;;



;; to do
;;
;;   vpath-include 
;;   vpath-flip 
;;   vpath-flip-directory 
;;     vpath-cdd         - change directory to development 
;;     vpath-cdr         - change directory to release
;;   vpath-file-diff
;;   vpath-dir-diff 
;;
;;  variables 
;;
;;     vpath-release-dir 
;;     vpath-development-dir 
;;
;; It would be nice if these did not conflict with the non-vpath 
;; include and flip functions. 
;;
;; Change the include and flip functions to accept a list of pathnames 
;; then the vpath and non-vpath can build the appropriate list and
;; pass it in. 
;;

(require 'include)
(require 'flip)

(defvar vpath-release-dir nil
  "*The path to the root of the RELEASE source code tree used for VPATH.
The path should *not* end in a slash. ")

(defvar vpath-development-dir nil
  "*The path to the root of the DEVELOPMENT source code tree used for VPATH.
The path should *not* end in a slash. ")

(defun vpath-include () 
  "Locate the included file specified on a #include line. Searches the 
VPATH directories to locate the file." 
  (interactive)
  (locate-include-file-in-path (make-vpath-include-dirs)))

(defun vpath-flip () 
  "Flip to the 'partner' file associated with the current buffer. 
Partner files are defined by the `flip-filename-replacements'
list. Searches for the partner file in the Uses the VPATH directories."
   (interactive)
   (flip-to-partner buffer-file-name (make-vpath-flip-dirs)))

(defun vpath-visit-reflection () 
"Visit this file stored in the 'other' VPATH tree if it exists."
  (interactive)
  (let ((fn (vpath-reflection-file-name buffer-file-name)))
    (if fn 
	(if (file-exists-p fn)
	    (if (file-readable-p fn)
		(find-file fn)
	      (princ "File not readable: ")
	      (princ fn)
	      (terpri)
              (beep))
	  (princ "File not found: ")
	  (princ fn)
	  (terpri)
	  (beep))
      (princ "Not in VPATH tree")
      (terpri)
      (beep))))

(defun vpath-file-diff ()
"Run EDIFF on the file and its reflection in the vpath tree."
 (interactive)
 (let ((file_a buffer-file-name)
       (file_b (vpath-reflection-file-name buffer-file-name)))
   (if file_b
       (if (file-directory-p file_b)
	   (ediff-files file_a file_b)
	 (princ "No reflection file: ")
	 (princ file_b)
	 (terpri)
	 (beep))
     (princ "Not in VPATH tree.")
     (terpri)
     (beep))))

(defun vpath-dired-flip () 
"Flip to the 'other' directory relative to the active VPATH root. 
If the buffer is located under the DEVELOPMENT directory then the 
corresponding RELEASE directory is visited and vice-versa."
  (interactive)
  (beep)
  (princ "vpath-dired-flip: not implemented yet...")
  (terpri)
   nil)

(defun vpath-dired-dir-diff () 
"Run a diff on the current directory contents versus the corresponding 
directory in the 'other' VPATH tree."
  (interactive)
  (beep)
  (princ "vpath-dired-dir-diff: not implemented yet...")
  (terpri)
   nil)

(defun vpath-dired-file-diff () 
"Run a diff on the marked file using the corresponding file in the 
'other' directory. "
  (interactive)
  (beep)
  (princ "vpath-dired-file-diff: not implemented yet...")
  (terpri)
   nil)


;; experiment 

(defun vpath-dir-files-diff ()
"Run EDIFF on all files in the current directory and its reflection 
directory in the vpath tree."
 (interactive)
 (let ((dir_a (file-name-directory buffer-file-name))
       (dir_b (vpath-reflection-directory-name buffer-file-name)))
   (if dir_b
       (if (file-exists-p dir_b)
;(progn (princ "got it: ")(princ dir_b)(terpri))
	   (ediff-directories dir_a dir_b ".*")
	 (princ "No reflection directory: ")
	 (princ dir_b)
	 (terpri)
	 (beep))
     (princ "Not in VPATH tree.")
     (terpri)
     (beep))))

;;;;;;;;;;;;;;;;;;;;;
;;
;; Helper functions 
;;
;;;;;;;;;;;;;;;;;;;;;


(defun vpath-reflection-file-name (filename)
"Returns the filename for the 'reflected' (or mirrored) file in the 
'other' VPATH tree. Returns nil if file is not part of either 
vpath tree."
   (if (string-match vpath-development-dir filename)
	(concat vpath-release-dir
                (substring filename 0 (match-beginning 0))
		(substring filename (match-end 0)))
     (if (string-match vpath-release-dir filename)
	(concat vpath-development-dir 
		(substring filename 0 (match-beginning 0))
		(substring filename (match-end 0)))
       nil)))

(defun vpath-reflection-directory-name (filename)
"returns the root directory of the 'other' VPATH tree. 
Returns NIL if the path is not in either the development or 
release trees."
   (if (string-match vpath-development-dir filename)
	(file-name-directory (concat vpath-release-dir
                (substring filename 0 (match-beginning 0))
		(substring filename (match-end 0))))
     (if (string-match vpath-release-dir filename)
	(file-name-directory (concat vpath-development-dir 
		(substring filename 0 (match-beginning 0))
		(substring filename (match-end 0))))
       nil)))

(defun vpath-in-development-dir () 
"Returns 't' if the current directory is in the development VPATH tree,
nil if not."
  (string-match vpath-development-dir buffer-file-name))

(defun vpath-in-release-dir () 
"Returns 't' if the current directory is in the development VPATH tree,
nil if not."
  (string-match vpath-release-dir buffer-file-name))
;; 
;; To use the VPATH stuff .. the DEVELOPMENT directory must always 
;; be searched before the RELEASE directory(s). 
;;
;; 
;;#############################
;;# The search order for includes always favors the DEVELOPMENT tree
;;#
;;# Header files come first from current directory 
;;# then same directory in release,
;;# then include/public in develop then release,
;;# then include/private in develop then release
;;#############################
;;
;;

(defun make-vpath-flip-dirs ()
"Return a list of directories that contain the VPATH directories to
 search for the 'flip' file. The VPATH directories must be created
 dynamically, they are relative to the current working directory"
(interactive)
(let ((path (file-name-directory (compute-buffer-file-truename)))
         (search-path (list)))

;(with-output-to-temp-buffer "*zob*"
;(princ "Flip:\n")
;(princ "  path=")
;(princ path)
;(princ "\n")

;(princ "   exp=")
;(princ (expand-file-name path))
;(princ "\n")
;(princ "   exp=")
;(princ (ange-ftp-real-expand-file-name path))
;(princ "\n")
;(princ "   exp=")
;(princ (compute-buffer-file-truename))
;(princ "\n")

      (if (or (string-match vpath-development-dir path)
	      (string-match vpath-release-dir path))
	  (let ((relpath (substring path (match-end 0))))

;(princ "v  rel=")
;(princ relpath)
;(princ "\n")

	    (setq search-path 
		  (list	(concat vpath-development-dir relpath )
			(concat vpath-release-dir relpath ))))
	(setq search-path (list path)))

;(princ search-path)
;(terpri)

   search-path))
;)


;; 
;; To use the VPATH stuff .. the DEVELOPMENT directory must always 
;; be searched before the RELEASE directory(s). 
;;
;; 
;;#############################
;;# The search order for includes always favors the DEVELOPMENT tree
;;#
;;# Header files come first from current directory 
;;# then same directory in release,
;;# then include/public in develop then release,
;;# then include/private in develop then release
;;#############################
;;
;;

(defun make-vpath-include-dirs ()
"Return a list of directories that contain the VPATH directories. 
 The VPATH directories must be created dynamically, they are relative 
 to the current working directory"
 (interactive)
 (let ((path (file-name-directory buffer-file-name))
       (search-path (list)))
   (if (or (string-match vpath-development-dir path)
	   (string-match vpath-release-dir path))
       (let ((relpath (substring path (match-end 0))))
	 (setq search-path 
	       (list	(concat vpath-development-dir relpath )
			(concat vpath-release-dir relpath )))))
   (setq search-path (append (list path) my-include-dirs))
;(with-output-to-temp-buffer "*zob*"
;(princ "Include:")
;(princ search-path)
;(terpri))
   search-path))

; not used .. yet
;(defun vpath-complain (arg1 arg2)
;  "Print the arguments and ring the bell"
;  (princ arg1)
;  (if arg2
;      (princ arg2))
;  (terpri)
;  (beep))

;;
(provide 'vpath)
