<HTML>
<HEAD><TITLE>Deja News Retrieved Document</TITLE></HEAD>
<BODY bgcolor="#FFFFFF" text="#000000" link="#0000FF" vlink="#52188C">
<A HREF="http://xp8.dejanews.com/getdoc.xp?recnum=9801476&server=db97p2x&CONTEXT=866586956.19181&hitnum=6"><IMG ALT="[Previous]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/prevart.gif"></A>
<A HREF="http://xp8.dejanews.com/getdoc.xp?recnum=9801474&server=db97p2x&CONTEXT=866586956.19181&hitnum=8"><IMG ALT="[Next]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/nextart.gif"></A>
<A HREF="http://xp8.dejanews.com/dnquery.xp?search=next&site=dn&offsets=&CONTEXT=866586956.19181"><IMG ALT="[Current Results]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/currsr.gif"></A>
<A HREF="http://xp8.dejanews.com/dnquery.xp?search=thread&filter=&svcclass=dncurrent&threaded=1&CONTEXT=866586956.19181&HIT_CONTEXT=866586956.19181&HIT_NUM=7&recnum=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e%231/13"><IMG ALT="[Get Thread]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/thread.gif"></A>
<A HREF="http://search.dejanews.com/profile.xp?author=Gerd%20Moellmann%20%3cmmann@ibm.net%3e"><IMG ALT="[Author Profile]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/authorprof.gif"></A>
<A HREF="http://postnews.dejanews.com/post.xp?NG=gnu.emacs.sources&SUB=Re:%20noweb.el%20(please%20read%20comment%20there)&REF=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e&server=db97p2x&recnum=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e"><IMG ALT="[Post]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/postrep.gif"></A>
<A HREF="http://postnews.dejanews.com/post.xp"><IMG ALT="[Post]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/postart.gif"></A>
<A HREF="mailto:mmann@ibm.net"><IMG ALT="[Reply]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/email.gif"></A>
<HR><H3>Article 8 of 22</H3><PRE>
<B>Subject:      <FONT SIZE=+1><A HREF="http://xp8.dejanews.com/dnquery.xp?search=thread&filter=&svcclass=dncurrent&threaded=1&HIT_CONTEXT=866586956.19181&HIT_NUM=7&recnum=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e">noweb.el (please read comment there)</A></FONT>
From:         <A HREF="http://search.dejanews.com/profile.xp?author=Gerd%20Moellmann%20%3cmmann@ibm.net%3e">Gerd Moellmann &lt;mmann@ibm.net&gt;</A>
Date:         1997/06/10
Message-Id:   &lt;87pvtubgnt.fsf@gerd.freebsd.ibm.net&gt;
Newsgroups:   gnu.emacs.sources
<A HREF="http://xp8.dejanews.com/getdoc.xp?recnum=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e&server=db97p2x&CONTEXT=866586956.19181&hitnum=7&AH=1">[More Headers]</A>
</B>
;;; noweb.el --- Mode for editing noweb source files

;; Copyright (C) 1997 Gerd Moellmann

;; Author:	  Gerd Moellmann &lt;gerd@acm.org&gt;
;; Maintainier:   Gerd Moellmann &lt;gerd@acm.org&gt;
;; Version:	  $Id: noweb.el,v 1.4 1997/06/10 15:44:13 gerd Exp $
;; Keywords:	  languages noweb

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; `Noweb' is a literate programming system written by Normal Ramsey.
;; Its home page is `http://www.cs.purdue.edu/homes/nr/noweb'.

;; This package implements a mode which lets you edit a noweb source
;; in language modes depending on whether you are editing
;; documentation or code parts of a web.  Which mode to use is
;; determined automatically by looking at chunk boundaries and scrap
;; names.  The package supports text highlighting with the `font-lock'
;; package.  Text and code parts of a web are highlighted according to
;; the mode in which they are edited.  Menus and marginal annotations
;; provide navigation between chunks.  Spell checks can be performed
;; on text parts only, ignoring code chunks.

;; The mode in which text parts are edited is determined from the
;; value of the variable `noweb-text-mode'.  It defaults to
;; `latex-mode'.  The package works with AUCTeX.

;; Code editing modes are determined in three ways.  If a scrap name
;; matches a pattern in `auto-mode-alist' the mode specified there is
;; used.  This means that a scrap named `file.el' will be edited in
;; Emacs Lisp mode.  Scrap names can also contain mode strings similar
;; to those used as file variables: `-*-LANG-*-'.  If such a mode
;; string is found, the scrap is edited in `LANG-MODE'.  Otherwise the
;; code editing mode is `noweb-code-mode' which defaults to C mode.

;; Mode strings can be stripped in the noweb pipeline with a simple
;; filter like the following shell script:

;; #! /bin/sh
;; # nomode - strip mode strings from code definitions
;; awk '/^@defn/ { sub(/[ \t]*-\*-.*-\*-[ \t]*/, &quot;&quot;, $0); }	      
;; 	{ print }'

;; The package expects to use `font-lock' highlighting. Text and code
;; parts are highlighted according to their mode as described above.
;; `fast-lock' and `lazy-lock' probably won't work with `noweb-mode'
;; because of the way major modes change over the buffer.

;; When `noweb-use-annotations' is set to `t', marginal annotations
;; are added to a noweb buffer that let you jump to previous and next
;; uses of scrap names in the buffer.  Marginal annotations glyphs are
;; borrowed from `outl-mouse'.  They look like small up and down
;; arrows.  A small `d' or `u' indicates whether a definition or use
;; is in the indicated direction. `Mouse-1' on an arrow jumps to the
;; previous or next scrap with the same name.  The function
;; `noweb-annotate-scraps' (also reachable via the Noweb menu) can be
;; called to re-build annotations.

;; `noweb-mode' adds a `Noweb' menu to the menu of the current major
;; mode popup menu and to the menu bar.  This menu contains some
;; navigational commands. Just take a look at it.

;;; Platforms:

;; This package has been used under XEmacs 19.13, and 19.15.  A port
;; to GNU Emacs has not yet been done.

;;; Installation:

;; To install this package, compile it and copy the compiled file to a
;; suitable location in your `load-path'. Then add the following lines
;; to your `.emacs':

;; (autoload 'noweb-mode &quot;noweb&quot; &quot;Noweb mode&quot; t)
;; (setq auto-mode-alist (append '(&quot;\\.nw$&quot; . noweb-mode)
;; 				  auto-mode-alist))
;; (custom-add-load 'languages 'noweb)

;; Do _not_ add a call to `noweb-mode' to a major mode hook! Since
;; `noweb-mode' changes major modes, this will lead to infinite
;; recursion.  Also, do _not_ add calls like `turn-on-font-lock' into
;; hooks for any major mode used in a web.

;;; Customization:

;; Everything customizable is made available through the XEmacs 
;; `custom' facility, i.e. via the menu item Options/Customize/
;; Emacs/Programming/Languages.

;;; Todo:

;; - find out how to react immediately when options are customized.
;; - outline minor mode: test it
;; - do something about tags in webs
;; - clean up commands over all noweb buffers.  Some use all
;;   buffes, others don't.

;;; Known Bugs:

;; - Depending on what is done in major mode hooks, infinite recursion
;; can result (e.g. when turning on `font-lock' in a major mode hook.)

;; - a custimized option will only take effect after a new buffer has
;; been loaded.

;;; Code:

(require 'cl)
(require 'font-lock)
(require 'advice)
(require 'custom)
(require 'annotations)
(require 'outl-mouse)			;for the nice arrow glyphs

(ad-start-advice)			;necessary?

;;; Switch off some warnings about unused variables.

(eval-when-compile
  (byte-compiler-options (warnings (- unused-vars))
			 (optimize t)))



;;; Version.

(defun noweb-version ()
  &quot;Return, and if interactively called, print the version number
of this package.  The version number is a float.&quot;
  (interactive)
  (let ((version (string-to-number (substring &quot;$Revision: 1.4 $&quot; 11))))
    (when (interactive-p)
      (message &quot;Noweb mode version %g&quot; version))
    version))



;;; Customization.

(defgroup noweb nil
  &quot;Group to customize noweb mode parameters.&quot;
  :group 'tools
  :group 'languages
  :tag &quot;Noweb&quot;
  :load 'noweb)


(defcustom noweb-mode-indicator &quot; Noweb&quot;
  &quot;The string used to indicate noweb mode in the mode line.&quot;
  :type 'string
  :tag &quot;Mode Indicator&quot;
  :group 'noweb)


(defcustom noweb-use-all-buffers-p nil
  &quot;Set to t when some commands in `noweb-mode' should operate on
all Noweb buffers instead of the current buffer, only.&quot;
  :tag &quot;Commands Over ALl Buffers&quot;
  :type '(boolean)
  :group 'noweb)



;;; Font/face customization.

(defgroup noweb-fonts nil
  &quot;Group for font usage.&quot;
  :tag &quot;Fonts&quot;
  :group 'noweb)


(defcustom noweb-fontify-chunks nil
  &quot;Use of different fonts for text and code chunks in a web.
If this option is `on', `noweb-mode' will use different faces for code
and text chunks. You can customize these fonts.&quot;
  :group 'noweb-fonts
  :type '(boolean)
  :tag &quot;Different Fonts for Text and Code&quot;)


(defface noweb-custom-text-face '((t (:family &quot;Helv&quot;)))
  &quot;The face to use for text chunks.  Note that this face is only used
when using different faces for code and text parts is switched on.&quot;
  :group 'noweb-fonts
  :tag &quot;Text Chunk Face&quot;)


(defface noweb-custom-code-face '((t ()))
  &quot;The face to use for code chunks.  Note that this face is only used
when using different faces for code and text parts is switched on.&quot;
  :group 'noweb-fonts
  :tag &quot;Code Chunk Face&quot;)



;;; Font-lock

(defgroup noweb-font-lock nil
  &quot;Customization group for font-lock faces&quot;
  :group 'noweb
  :tag &quot;Hightlighting&quot;)


(defface noweb-defn-face 
  '((((class color) (background dark))
     (:foreground &quot;blue&quot; :bold t))
    (((class color) (background light))
     (:foreground &quot;darkblue&quot; :bold t))
    (t
     (:bold t)))
  &quot;Face used to highlight &lt;&lt;.*&gt;&gt;=.&quot;
  :tag &quot;Face for scrap definitions&quot;
  :group 'noweb-font-lock)


(defface noweb-use-face 
  '((((class color) (background dark))
     (:foreground &quot;blue&quot;))
    (((class color) (background light))
     (:foreground &quot;darkblue&quot;))
    (t 
     (:italic t :bold t)))
  &quot;Face used to highlight &lt;&lt;.*&gt;&gt; uses.&quot;
  :tag &quot;Face for Scrap Uses&quot;
  :group 'noweb-font-lock)


(defface noweb-ref-face
  '((((class color) (background dark))
     (:foreground &quot;blue&quot;))
    (((class color) (background light))
     (:foreground &quot;darkblue&quot;))
    (t 
     (:itelic t)))
  &quot;Face used to highlight [[.*]].&quot;
  :tag &quot;Face to hightlight references&quot;
  :group 'noweb-font-lock)


(defcustom noweb-font-lock-ref-regexp &quot;\\[\\[[^]]*\\]\\]&quot;
  &quot;Regular expression for hightlighting references.&quot;
  :type '(string)
  :tag &quot;Font-lock References&quot;
  :group 'noweb-font-lock)


(defcustom noweb-font-lock-use-regexp &quot;&lt;&lt;.*&gt;&gt;&quot;
  &quot;Regular expression for hightlighting scrap uses.&quot;
  :type '(string)
  :tag &quot;Font-lock Scrap Uses&quot;
  :group 'noweb-font-lock)


(defcustom noweb-font-lock-definition-regexp &quot;^&lt;&lt;.*&gt;&gt;=&quot;
  &quot;Regular expression for hightlighting scrap definitions.&quot;
  :type '(string)
  :tag &quot;Font-lock Scrap Definitions&quot;
  :group 'noweb-font-lock)


(defcustom noweb-code-keywords 
  '(c-font-lock-keywords 
    c-font-lock-keywords-1 c-font-lock-keywords-2
    c-font-lock-keywords-3 
    c++-font-lock-keywords c++-font-lock-keywords-1
    c++-font-lock-keywords-2 c++-font-lock-keywords-3
    lisp-font-lock-keywords lisp-font-lock-keywords-1
    lisp-font-lock-keywords-2)
  &quot;List of where to add our font-lock code chunk specific regular 
expression to (see also `font-lock.el'.&quot;
  :type '(sexp)
  :tag &quot;Where to Add Code Regexps&quot;
  :group 'noweb-font-lock)


(defcustom noweb-text-keywords 
  '(tex-font-lock-keywords
    font-latex-keywords font-latex-keywords-1
    font-latex-keywords-2)
  &quot;List of where to add our font-lock text chunk specific regular 
expression to (see also `font-lock.el'.&quot;
  :type '(sexp)
  :tag &quot;Where to Add Text Regexps&quot;
  :group 'noweb-font-lock)



;;; Annotations stuff.

(defgroup noweb-annotations nil
  &quot;Customization group for annotations.&quot;
  :tag &quot;Annotations&quot;
  :group 'noweb)


(defcustom noweb-use-annotations t
  &quot;Building annotations on the left margin.

If this option is `on' `noweb-mode' will build annotations on the left
margin of web buffers that let you navigate between scraps.&quot;
  :group 'noweb-annotations
  :type '(boolean)
  :tag &quot;Build Annotations&quot;)


(defcustom noweb-left-margin-width 8
  &quot;The size of the left margin.&quot;
  :group 'noweb-annotations
  :type '(integer)
  :tag &quot;Left Margin Width&quot;)


(defcustom noweb-left-margin-background-color &quot;gray80&quot;
  &quot;The color to use for the left margin.&quot;
  :group 'noweb-annotations
  :type '(string)
  :tag &quot;Left Margin Background&quot;)



;;; Keyboard

(defgroup noweb-keyboard nil
  &quot;Group for everything which has to do with the keyboard.&quot;
  :group 'noweb
  :tag &quot;Keyboard&quot;)


(defcustom noweb-prefix-key &quot;\C-c\C-n&quot;
  &quot;Prefix key for noweb mode commands.&quot;
  :type '(string)
  :tag &quot;Prefix Key&quot;
  :group 'noweb-keyboard)


(defcustom noweb-beware-electric-&lt;-forms 
  '((not (eq major-mode 'c++-mode)))
  &quot;List of forms to check if electric `&lt;&lt;...&gt;&gt;' insertion is desirable.&quot;
  :type '(sexp)
  :tag &quot;Electric `&lt;' Expansion&quot;
  :group 'noweb-keyboard)

(make-variable-buffer-local 'noweb-beware-electric-&lt;-forms)
(put 'noweb-beware-electric-&lt;-forms 'permanent-local t)



;;; Default modes.

(defgroup noweb-modes nil
  &quot;Group for default noweb modes.&quot;
  :group 'noweb
  :tag &quot;Modes&quot;)

(defcustom noweb-text-mode 'latex-mode
  &quot;The default mode to use for editing text parts of a web.&quot;
  :type '(symbol)
  :tag &quot;Default Text Mode&quot;
  :group 'noweb-modes)


(defcustom noweb-code-mode 'c-mode
  &quot;The default mode for editing code parts of a web.&quot;
  :type '(symbol)
  :tag &quot;Default Code Mode&quot;
  :group 'noweb-modes)

(make-variable-buffer-local 'noweb-text-mode)
(put 'noweb-text-mode 'permanent-local t)
(make-variable-buffer-local 'noweb-code-mode)
(put 'noweb-code-mode 'permanent-local t)



;;; Hooks.

(defgroup noweb-hooks nil
  &quot;Customization group for hooks.&quot;
  :tag &quot;Hooks&quot;
  :group 'noweb)
  

(defcustom noweb-mode-change-hook nil
  &quot;Hooks run after major mode changes in noweb buffers.  Registered
functions are called with no arguments.&quot;
  :type '(sexp)
  :tag &quot;Mode Change&quot;
  :group 'noweb-hooks)


(defcustom noweb-menubar-hook nil
  &quot;Hooks run after chaning modes and installing menus.  This hook
can be used to re-install minor mode menus.&quot;
  :type '(sexp)
  :tag &quot;Menu Change&quot;
  :group 'noweb-hooks)


(defcustom noweb-load-hook nil
  &quot;Hook run when `noweb-mode' is loaded.&quot;
  :type '(sexp)
  :tag &quot;Load&quot;
  :group 'noweb-hooks)



;;; Regular expressions.

(defgroup noweb-regexps nil
  &quot;Customization group for regular expressions.&quot;
  :tag &quot;Regular Expressions&quot;
  :group 'noweb)


(defcustom noweb-scrap-name-start-regexp &quot;&lt;&lt;&quot;
  &quot;Regular expression matching the start of a scrap name. Definitions
are assumed to start in column 1 so that this regular expression,
with a prepended `^' is used to match the start of a definition.&quot;
  :type '(string)
  :tag &quot;Scrap Name Start&quot;
  :group 'noweb-regexps)


(defcustom noweb-scrap-name-end-regexp &quot;&gt;&gt;&quot;
  &quot;Regular expression matching the end of a scrap name&quot;
  :type '(string)
  :tag &quot;Scrap Name End&quot;
  :group 'noweb-regexps)


(defcustom noweb-scrap-defn-name-end-regexp &quot;&gt;&gt;=&quot;
  &quot;Regular expression matching the end of a scrap name in a 
definition.&quot;
  :type '(string)
  :tag &quot;Scrap Definition&quot;
  :group 'noweb-regexps)


(defcustom noweb-scrap-use-name-end-regexp &quot;&gt;&gt;[^=]&quot;
  &quot;Regular expression matching *only* the end of a scrap name in a 
scrap use.&quot;
  :type '(string)
  :tag &quot;Scrap Use&quot;
  :group 'noweb-regexps)
  

(defcustom noweb-code-start-regexp 
  (concat &quot;^&quot; noweb-scrap-name-start-regexp &quot;\\(.*\\)&quot;
	  noweb-scrap-defn-name-end-regexp)
  &quot;Regular expression that matches the beginning of a code part.
Must include a sub-expression that matches the scrap name.&quot;
  :type '(string)
  :tag &quot;Code Start&quot;
  :group 'noweb-regexps)


(defcustom noweb-scrap-name-regexp &quot;[^@]&lt;&lt;\\([^\r\n]*\\)&gt;&gt;&quot;
  &quot;Regular expression used to extract scrap names.&quot;
  :type '(string)
  :tag &quot;Scrap Names&quot;
  :group 'noweb-regexps)


(defcustom noweb-text-start-regexp &quot;^@&quot;
  &quot;Regular expression matching the start of a text part.&quot;
  :type '(string)
  :tag &quot;Text Start&quot;
  :group 'noweb-regexps)


(defcustom noweb-mode-string-regexp &quot;-\\*-[ \t]*\\([^ \t]+\\)[ \t]*-\\*-&quot;
  &quot;A regular expression matching a mode string in a scrap name.&quot;
  :type '(string)
  :tag &quot;Mode Strings&quot;
  :group 'noweb-regexps)



;;; Other Lisp stuff

(defcustom noweb-beware-forms 
  '((not isearch-mode)
    (not (and (boundp 'gdbsrc-mode) (symbol-value 'gdbsrc-mode)))
    (not noweb-scrollbar-vertical-drag-p))
  &quot;List of forms to check to determine if mode changes are desirable.&quot;
  :type '(sexp)
  :tag &quot;Mode Change Beware&quot;
  :group 'noweb-lisp)


(defcustom noweb-local-variables-to-make-permanent
  '(post-command-hook
    toolbar-ispell-function
    auto-show-mode 
    outline-fold-in-function outline-fold-out-function outline-regexp
    outline-level
    TeX-master
    view-minor-mode view-exit-position view-exit-action view-prev-buffer)
  &quot;A list of local variables that should be preserved across major 
mode changes done by `noweb-mode'.

Local variables are preserved by giving them the `permanent-local'
property.  (I am not sure whether it is be a good idea to make
variables `permanent-local'. On one hand major mode changes are rare,
so probably a user will not notice any difference.  On the other hand
anything relying on `kill-all-local-variables'to really kill these
variables will break.)&quot;
  :type '(sexp)
  :tag &quot;Permanent Local Variables&quot;
  :group 'noweb-lisp)



;;; Menu stuff

(defgroup noweb-menu nil
  &quot;Group for customizable menu.&quot;
  :tag &quot;Menu&quot;
  :group 'noweb)


(defcustom noweb-max-scrap-menu-items 30
  &quot;The maximum number of menu items in a scrap menu. If more scraps
are found in a buffer, `noweb-mode' construct a tree menu structure.&quot;
  :tag &quot;Number of Menu Entries&quot;
  :type '(integer)
  :group 'noweb-menu)


(defcustom noweb-mode-menu
  '(&quot;Noweb&quot; :included noweb-mode
    (&quot;Scrap at Point&quot; :included (noweb-in-scrap-name-p)
     [&quot;Jump to First Occurrence&quot; noweb-jump-to-first-occurrence :active t]
     [&quot;Jump to Previous Occurrence&quot; noweb-jump-to-previous-occurrence 
      :active (noweb-exists-previous-scrap-p)]
     [&quot;Jump to Next Occurrence&quot; noweb-jump-to-next-occurrence 
      :active (noweb-exists-next-scrap-p)]
     &quot;--&quot;
     [&quot;List All Uses&quot; noweb-list-all-uses :active t]
     [&quot;List All Definitions&quot; noweb-list-all-definitions :active t]
     [&quot;List All&quot; noweb-list-all-uses&amp;definitions :active t])
    (&quot;Goto First Scrap Definition&quot; :filter noweb-goto-scrap-defn-filter)
    (&quot;Goto First Scrap Use&quot; :filter noweb-goto-scrap-use-filter)
    &quot;--&quot;
    [&quot;Spell Text Parts&quot; noweb-ispell-function :active t]
    [&quot;Re-build Annotations&quot; noweb-annotate-scraps :active t]
    [&quot;Re-fontify&quot; noweb-fontify-buffer :active t]
    &quot;--&quot;
    [&quot;Use Different Fonts for Text and Code&quot; noweb-toggle-fonts
     :active t :style toggle :selected noweb-fontify-chunks]
    [&quot;Operate on All Noweb Buffers&quot; noweb-toggle-buffers-to-use
     :active t :style toggle :selected noweb-use-all-buffers-p])
  &quot;The noweb menu definition.&quot;
  :tag &quot;Noweb Menu&quot;
  :type '(sexp)
  :group 'noweb-menu)



;;; Variables that are not customizable.

(defvar noweb-mode nil
  &quot;Set to T if in noweb mode&quot;)

(make-variable-buffer-local 'noweb-mode)
(put 'noweb-mode 'permanent-local t)


(defvar noweb-mode-map nil
  &quot;The keymap used in noweb minor mode.&quot;)


(defvar noweb-scrollbar-vertical-drag-p nil
  &quot;Set to T when the user drags the scrollbar vertically.&quot;)


(defvar noweb-code-face (copy-face 'default 'noweb-code-face)
  &quot;The face used for code chunks.&quot;)



;;; Scrollbars

(defadvice scrollbar-vertical-drag 
  (around noweb-scrollbar-vertical-drag activate compile) 
  &quot;Set `noweb-scrollbar-vertical-drag-p' to t while the user is dragging
the scroll bar. When this variable is t do not chnage modes.&quot;
  (unwind-protect
      (progn
	(setq noweb-scrollbar-vertical-drag-p t)
	ad-do-it)
    (setq noweb-scrollbar-vertical-drag-p nil)))
	



;;; Menu functions (XEmacs only).

(defun noweb-add-menu-to-menubar ()
  &quot;Add noweb menu to the menu for the current major mode if the major
mode&quot;
  (condition-case nil
      (find-menu-item current-menubar &quot;Noweb&quot; nil)
    (error (add-submenu nil noweb-mode-menu))))


(defun noweb-add-menu-to-popup-menu ()
  &quot;Add the noweb menu to the buffers popup menu.&quot;
  (condition-case nil
      (when (and mode-popup-menu 
		 (null (car (find-menu-item mode-popup-menu
					    (list (car noweb-mode-menu))))))
	(setq mode-popup-menu (append mode-popup-menu
				      (list (vector &quot;--&quot; nil nil) 
					    noweb-mode-menu))))
    (error nil)))


(defun noweb-add-menus ()
  &quot;Add the noweb menu to the menubar and to the current major mode
popup menu.  If in `outline-minor-mode' also add the outline menus
to the menu bar.&quot;
  (noweb-add-menu-to-menubar)
  (noweb-add-menu-to-popup-menu)
  (when outline-minor-mode
    (outline-install-menubar))
  (run-hooks 'noweb-menubar-hook))



;;; Noweb mode.

;;;###autoload
(defun noweb-mode (&amp;optional arg)
  &quot;Turn on/off noweb mode. `noweb-mode' will let you edit text and
code chunks of your web in suitable major modes with `font-lock'
highlighting depending on the modes used.

The mode for text parts is determined from the buffer local variable
`noweb-text-mode' which is `latex-mode' by default.  The mode to use
for code chunks is determined in three ways: If the scrap name of the
chunk matches a regular expression in `auto-mode-alist', the mode
there will be used.  If the scrap name contains a string of the form
`-*-LANGUAGE-*-' the chunk will be edited in `LANGUAGE-mode'.  If both
is not the case, `noweb-code-mode' is used which is a buffer local
variable defaulting to `c-mode'.

\\{noweb-mode-map}&quot;
  (interactive &quot;P&quot;)
  (setq noweb-mode (if (null arg) 
		       (not noweb-mode)
		     (&gt; (prefix-numeric-value arg) 0)))
  (if noweb-mode
      (progn
	;; Make sure `font-lock-fontified' is local, otherwise other
	;; buffers won't be fontified when it is set inadvertantly.
	(loop for sym in noweb-local-variables-to-make-permanent do
	      (put sym 'permanent-local t))
	(make-local-variable 'font-lock-fontified)
	(set (make-local-variable 'revert-buffer-function) 'noweb-revert-buffer)
	(set (make-local-variable 'toolbar-ispell-function) 'noweb-ispell-function)
	(noweb-fontify-buffer)
	(make-local-hook 'post-command-hook)
	(add-hook 'post-command-hook 'noweb-post-command-hook-fn)
	(run-hooks 'noweb-mode-hook))
    (remove-hook 'post-command-hook 'noweb-post-command-hook-fn)
    (setq revert-buffer-function nil))
  (redraw-modeline))



;;; Switching modes.

(defsubst noweb-mode-from-auto-mode-alist (scrap-name)
  &quot;Scan `auto-mode-alist' for a mode matching `scrap-name'. Return
the match found or nil.&quot;
  (rest (find-if #'(lambda (x) (string-match (first x) scrap-name))
                 auto-mode-alist)))


(defsubst noweb-mode-from-mode-string (scrap-name)
  &quot;Return a mode from a mode string in `scrap-name'.  Mode strings have
the usual form described by `noweb-mode-string-regexp'.  Returns nil if
the scrap name does not contain a mode string.&quot;
  (let (mode)
    (when (string-match noweb-mode-string-regexp scrap-name)
      (let ((language 
	     (downcase (substring scrap-name (match-beginning 1) (match-end 1)))))
	(setf mode (intern-soft (concat language &quot;-mode&quot;)))
	(when (and mode (not (fboundp mode)))
	  (setf mode nil))))
    mode))


(defsubst noweb-code-mode (scrap-name)
  &quot;Determine the mode for a code chunk from a given scrap name
`scrap-name'.  If `scrap-name' matches a pattern in `auto-mode-alist',
use the mode from there.  If `scrap-name' contains a mode string of
the form \&quot;-*-LANGUAGE-*-\&quot; use `LANGUAGE-mode'.  Otherwise, return
the default code mode `noweb-code-mode'.&quot;
  (or (noweb-mode-from-auto-mode-alist scrap-name)
      (noweb-mode-from-mode-string scrap-name)
      noweb-code-mode))


(defun noweb-switch-to-mode (mode &amp;optional leave-menus-alone-p)
  &quot;Switch to major mode `mode' unless we are already in that mode.
If optional `leave-menus-alone' is nil, make sure the noweb menu
is present in the menu bar.  Runs the hooks `noweb-chnage-mode-hook'.
and `noweb-menubar-hook'.&quot;
  (let ((switch-p (not (eq major-mode mode))))
    (when switch-p
      (let ((font-lock-fontified t))
 	(if leave-menus-alone-p
	    (funcall mode)
	  ;; Reset the menubar of this buffer because we do not want
	  ;; the C menu in LaTeX parts, for example.  This has the
	  ;; unfortunate effect of removing menus that are added by
	  ;; packages like `function-menu' on a per mode basis, but
	  ;; there is nothing we can do about it.
	  
	  ;; Note also that XEmacs detects changes to the menubar
	  ;; automatically so there is also nothing we can do to
	  ;; reduce menubar updating.
	  (set-buffer-menubar default-menubar)
	  (setq mode-popup-menu default-popup-menu)
	  (funcall mode)
	  (noweb-add-menus)
	  (noweb-set-left-margin))
	(run-hooks 'noweb-mode-change-hook)
	(make-local-hook 'post-command-hook)
	(add-hook 'post-command-hook 'noweb-post-command-hook-fn)
	(turn-on-font-lock)))
    switch-p))



;;; Post command hook.

(defun noweb-post-command-hook-fn ()
  &quot;Called after every command in a buffer. If we are in noweb mode
and there is nothing to prevent us from switching modes (see
NOWEB-BEWARE-FORMS), try if we have to change modes and do so.&quot;
  (when (and noweb-mode (eval (cons 'and noweb-beware-forms)))
    (let* ((scrap-end 
	    (save-excursion (re-search-backward noweb-text-start-regexp nil t))) 
	   (scrap-start
	    (save-excursion (re-search-backward noweb-code-start-regexp nil t)))
	   (mode (if (or (and (null scrap-start) (null scrap-end))
			 (and scrap-end (&lt; scrap-start scrap-end)))
		     noweb-text-mode
		   (noweb-code-mode (buffer-substring (match-beginning 1) 
						      (match-end 1))))))
	(noweb-switch-to-mode mode))))



;;; Fontification.

(defmacro noweb-for-all-text-parts (start-point &amp;rest forms)
  &quot;Evaluate form on all text parts.  START and END will be bound
to the start and end of the region of a text part, when FORM is
evaluated.&quot;
  `(let (start end)
     (goto-char ,start-point)
     (setq start (point))
     (noweb-switch-to-mode noweb-text-mode 'leave-menus-alone)
     (while (setq end (re-search-forward noweb-code-start-regexp nil t))
       ,@forms
       (re-search-forward noweb-text-start-regexp nil t)
       (setq start (point)))
     (when (&lt; start (point-max))
       (setq end (point-max))
       ,@forms)))


(defmacro noweb-for-all-code-parts (start-point &amp;rest forms)
  &quot;Evaluate form on all code parts.  START and END will be bound
to the start and end of the region of a text part, when FORM is
evaluated.&quot;
  `(let (start)
     (goto-char ,start-point)
     (while (setq start (re-search-forward noweb-code-start-regexp nil t))
       (let ((scrap (buffer-substring (match-beginning 1) (match-end 1)))
	     (end (re-search-forward noweb-text-start-regexp nil t)))
	 (when end
	   (noweb-switch-to-mode (noweb-code-mode scrap) 'leave-menus-alone)
	   ,@forms)))))

(put 'noweb-for-all-text-parts 'lisp-indent-function 1)
(put 'noweb-for-all-code-parts 'lisp-indent-function 1)


(defmacro noweb-fontify-region (start end)
  &quot;Do the necessary steps to fontify a region `start' and `end'.&quot;
  (if (fboundp 'font-lock-hack-keywords)
      `(save-excursion
	 (font-lock-fontify-region ,start ,end)
	 (font-lock-hack-keywords ,start ,end))
    `(save-excursion
       (font-lock-fontify-region ,start ,end))))


(defsubst noweb-make-code-extent (start end)
  (unless (extent-at start (current-buffer) 'noweb)
    (let ((extent (make-extent start end)))
      (set-extent-property extent 'noweb 'code-part)
      (set-extent-face extent 'noweb-code-face))))


(defun noweb-unfontify-buffer ()
  &quot;Remove fontification of the current buffer.&quot;
  (font-lock-unfontify-region (point-min) (point-max))
  (setq font-lock-fontified nil))


(defun noweb-fontify-buffer ()
  &quot;Fontify a whole noweb buffer. Text and code parts are fontified
according to the mode they are edited in.&quot;
  (interactive)
  (save-restriction
    (widen)
    (let ((initial-mode major-mode))
      (condition-case nil
	  (save-excursion
	    (save-match-data
	      (noweb-unfontify-buffer)
	      (display-message 'progess &quot;Fontifying text parts..:&quot;)
	      (noweb-for-all-text-parts (point-min) 
		(noweb-fontify-region start end))
	      (display-message 'progress &quot;Fontifying code parts...&quot;)
	      (noweb-for-all-code-parts (point-min)
		(noweb-make-code-extent start end)
		(noweb-fontify-region start end))
	      (noweb-switch-to-mode initial-mode)
	      (setq font-lock-fontified t))
	    (when noweb-use-annotations
	      (display-message 'progress &quot;Adding annotations...&quot;)
	      (noweb-annotate-scraps))
	    (clear-message 'progress))
	(quit 
	 (noweb-switch-to-mode initial-mode)
	 (noweb-unfontify-buffer))))))



;;; Commands.

(defun noweb-toggle-buffers-to-use ()
  (interactive)
  (setq noweb-use-all-buffers-p (not noweb-use-all-buffers-p)))

(defmacro noweb-in-noweb-buffers (&amp;rest forms)
  &quot;Evaluate `forms' in either the current buffer or in all noweb buffers,
depending on the value of `noweb-use-all-buffers-p'.&quot;
  `(loop for buffer in (if noweb-use-all-buffers-p
			   (buffer-list)
			 (list (current-buffer)))
	 when (symbol-value-in-buffer 'noweb-mode buffer)
	 do (save-excursion (set-buffer buffer)
			    (save-restriction
			      (widen)
			      (progn ,@forms)))))

(put 'noweb-in-noweb-buffers 'lisp-indent-function 0)


(defun noweb-scrap-name-alist (&amp;optional exclude-start exclude-end)
  &quot;Build and return a ALIST of all scrap definitions and uses in 
either the current buffer or in all noweb buffer, depending on the 
value of `noweb-use-all-buffers-p'.  Ignore scraps between 
`exclude-start' and `exclude-end' in the current buffer.  The `cdr'
of each cell in the alist is a list '(POINT DEFINITION-P BUFFER)'
where `point' is the position where the scrap was found, `definition-p'
is t if it was a scrap definition, and `buffer' is the buffer in which
the scrap was found.&quot;
  (let (alist (initial-buffer (current-buffer)))
    (noweb-in-noweb-buffers
      (goto-char (point-min))
      (while (re-search-forward noweb-scrap-name-regexp nil t)
	(when (or (not (eq (current-buffer) initial-buffer))
		  (or (null exclude-start) (&lt; (point) exclude-start))
		  (or (null exclude-end) (&gt; (point) exclude-end)))
	  (let ((scrap (buffer-substring (match-beginning 1) (match-end 1))))
	    (push (cons (noweb-strip-scrap-name scrap)
			(list (point) (looking-at &quot;=&quot;) (current-buffer)))
		  alist)))))
    (nreverse alist)))


(defun noweb-scrap-name-set (&amp;optional exclude-start exclude-end)
  &quot;Build and return a ALIST of all scraps in the current buffer.
Don't mention a scrap name more than once.&quot;
  (remove-duplicates (noweb-scrap-name-alist exclude-start exclude-end)
		     :key 'car :test 'string=))


(defun noweb-list-to-forest (list nitems)
  &quot;Given a LIST of items, transform it into a list of trees so 
that the result has no more than NITEMS items.&quot;
  (if (&gt; (length list) nitems)
      (let (sublist i result)
	(while list
	  (setf i 0 sublist nil)
	  (while (and list (&lt; i nitems))
	    (incf i)
	    (setq sublist (cons (car list) sublist))
	    (setq list (cdr list)))
	  (setf result (cons (nreverse sublist) result)))
	(noweb-list-to-forest (nreverse result) nitems))
    list))


(defun noweb-insert-menu-titles (forest)
  &quot;Given a list of trees as built by `noweb-list-to-forest', insert
menu title strings at the start of each non-leaf node.&quot;
  (let ((list forest))
    (while list
      (when (listp (car list))
	(setf (car list) (noweb-insert-menu-titles (car list))))
      (setq list (cdr list)))
    (if (listp (car forest))
	(cons (car (car forest)) forest)
      (cons (concat (aref (car forest) 0) &quot;...&quot;) forest))))


(defun noweb-scrap-name-items (callback)
  &quot;Build a menu structure from all scrap names in the current buffer.
CALLBACK is a function to be called when a menu item is activated.  It
will get passed the title of the menu item when called.&quot;
  (flet ((make-item (x) (vector (car x) (list callback (car x)) t))
	 (sort-items (x y) (string&lt; (aref x 0) (aref y 0))))
    (let ((scrap-list (mapcar 'make-item (noweb-scrap-name-set))))
      (setq scrap-list (sort scrap-list 'sort-items))
      (setq scrap-list (noweb-list-to-forest scrap-list noweb-max-scrap-menu-items))
      ;; The title of the top-most menu structure is not used
      (cdr (noweb-insert-menu-titles scrap-list)))))


(defun noweb-goto-scrap-defn-filter (list-of-items)
  &quot;Return a menu structure in which each menu item activation calls
NOWEB-GOTO-SCRAP with the name of the menu item (the scrap name).&quot;
  (noweb-scrap-name-items 'noweb-goto-scrap-defn))


(defun noweb-goto-scrap-use-filter (list-of-items)
  &quot;Return a menu structure in which each menu item activation calls
NOWEB-GOTO-SCRAP-USE with the name of the menu item (the scrap name).&quot;
  (noweb-scrap-name-items 'noweb-goto-scrap-use))


(defun noweb-switch-buffer (scrap)
  (when noweb-use-all-buffers-p
    (let* ((scrap-set (noweb-scrap-name-set))
	   (info (find-if #'(lambda (x) (string= (car x) scrap)) scrap-set)))
      (unless info (error &quot;No info about scrap&quot;))
      (switch-to-buffer (nth 2 (cdr info))))))
  

(defun noweb-goto-scrap (scrap what)
  &quot;Jump to a definition or use of `scrap'. `what' is either 'definition
or 'use.  When `noweb-use-all-buffers-p' is nil, search for the scrap
in the current buffer.  Otherwise, get the list of all scraps, and
find out the buffer.&quot;
  (noweb-switch-buffer scrap)
  (let ((regexp (noweb-build-scrap-regexp scrap what)))
    (goto-char (point-min))
    (unless (re-search-forward regexp nil t)
      (error &quot;Not found `%s'.&quot; regexp))
    (goto-char (match-beginning 1))
    (when outline-minor-mode (show-all))
    (noweb-recenter)))


(defun noweb-goto-scrap-defn (scrap)
  &quot;Menu action that jump to the first definition of `scrap'.&quot;
  (noweb-goto-scrap scrap 'definition))


(defun noweb-goto-scrap-use (scrap)
  &quot;Menu action that jump to the first use of `scrap'.&quot;
  (noweb-goto-scrap scrap 'use))



;;; Electric text insertion

(defun noweb-insert-noweb-scrap-name-in-code-chunk ()
  &quot;Insert a &lt;&lt;&gt;&gt; at point if appropriate. Return T if inserted.&quot;
  (let (inserted)
    (when (eval (cons 'and noweb-beware-electric-&lt;-forms))
      (cond ((bolp)
	     (insert &quot;&lt;&lt;&gt;&gt;&quot;)
	     (backward-char 2)
	     (indent-according-to-mode)
	     (setq inserted t))
	    ((and (char-equal (preceding-char) ?\&lt;)
		  (not (char-equal (char-after (- (point) 2)) ?\@)))
	     (insert &quot;&lt;&gt;&gt;&quot;)
	     (backward-char 2)
	     (indent-according-to-mode)
	     (setq inserted t))))
    inserted))


(defun noweb-insert-noweb-scrap-name-in-text-chunk ()
  &quot;Insert text for a noweb scrap definition into buffer if appropriate.
Return T if inserted.&quot;
  (let (inserted)
    (when (bolp)
      (insert &quot;&lt;&lt;&gt;&gt;=\n&quot;)
      (save-excursion (insert &quot;\n@ %def \n&quot;))
      (noweb-make-code-extent (point) (+ 1 (point)))
      (backward-char 4)
      (setq inserted t))
    inserted))


(defun noweb-electric-&lt; ()
  &quot;Insert scrap uses or definitions into the buffer depending
on where we are in the web.&quot;
  (interactive)
  (unless (or (and (looking-at &quot;[ \t]*$&quot;)
		   (noweb-in-code-chunk-p)
		   (noweb-insert-noweb-scrap-name-in-code-chunk))
	      (noweb-insert-noweb-scrap-name-in-text-chunk))
    (self-insert-command 1)))


(defun noweb-make-region-reference (arg)
  &quot;Make selected region a reference. With a prefix arg, also
surround the reference with `...'&quot;
  (interactive &quot;P&quot;)
  (unless (region-active-p) 
    (error &quot;The mark is not active now&quot;))
  (save-excursion
    (let ((prefix (if arg &quot;`[[&quot; &quot;[[&quot;))
	  (suffix (if arg &quot;]]'&quot; &quot;]]&quot;)))
      (goto-char (region-end))
      (insert suffix)
      (goto-char (region-beginning))
      (insert prefix))))


(defun noweb-electric-bracket (&amp;optional arg)
  &quot;Insert a noweb reference.  If characters follow point, tries
to be smart and inserts the reference around the next word, unless
given a prefix key.&quot;
  (interactive &quot;P&quot;)
  (when (and (&gt; (point) (point-min))
	     (char-equal (char-after (1- (point))) ?\[))
    (save-excursion
      (unless (or arg (looking-at &quot;[ \t]*$&quot;))
	(skip-chars-forward &quot;a-zA-Z0-9_&quot;))
      (insert &quot;]]&quot;)))
  (self-insert-command 1))


(defsubst noweb-start-of-line-point ()
  &quot;Return point at the start of the line.&quot;
  (save-excursion (beginning-of-line) (point)))


(defsubst noweb-end-of-line-point ()
  &quot;Return point at the end of the line.&quot;
  (save-excursion (end-of-line) (point)))


(defun noweb-scrap-name-start ()
  &quot;Return point at which a scrap name starts.  Returns NIL if not 
in a scrap name.&quot;
  (save-excursion
    (and (re-search-backward noweb-scrap-name-start-regexp 
			     (noweb-start-of-line-point) t)
	 (match-end 0))))


(defun noweb-scrap-name-end ()
  &quot;Return the point at which a scrap name ends.  Returns NIL if 
the end of the scrap could not be found (on the same line).&quot;
  (save-excursion
    (and (re-search-forward noweb-scrap-name-end-regexp 
			    (noweb-end-of-line-point) t)
	 (match-beginning 0))))


(defun noweb-in-scrap-name-p ()
  &quot;Return T if inside a scrap name.&quot;
  (and (not (null (noweb-scrap-name-start)))
       (not (null (noweb-scrap-name-end)))))


(defun noweb-push-completing-events ()
  &quot;Depending on the Emacs version, push events so that a we will see
the maximal completion in the minibuffer without hitting TAB
manually.&quot;
  (push (character-to-event ?\t) unread-command-events)
  (push (character-to-event ?\t) unread-command-events))


(defun noweb-complete-scrap ()
  &quot;Complete the scrap name in front of point from the scraps used
in the current buffer.&quot;
  (interactive)
  (if (noweb-in-scrap-name-p)
      (let* ((start (noweb-scrap-name-start))
	     (scrap (buffer-substring start (point)))
	     (line-start (noweb-start-of-line-point))
	     (line-end (noweb-end-of-line-point))
	     (alist (noweb-scrap-name-set line-start line-end))
	     (completion-ignore-case t)
	     (choice (progn
		       (noweb-push-completing-events)
		       (completing-read &quot;Scrap name: &quot; alist nil nil scrap))))
	(when choice
	  (delete-region start (or (noweb-scrap-name-end) line-end))
	  (insert choice)))
    (indent-according-to-mode)))


(defun noweb-trim (string what)
  &quot;Strip white space from STRING.  Second argument WHAT is a symbol
specifying from which end(s) of the string white space should be
stripped.  It can be 'both, 'leading or 'trailing.&quot;
  (when (and (memq what '(both leading))
	     (string-match &quot;^[ \t]+&quot; string))
    (setq string (substring string (match-end 0))))
  (when (and (memq what '(both trailing))
	     (string-match &quot;[ \t]+$&quot; string))
    (setq string (substring string 0 (match-beginning 0))))
  string)


(defun noweb-strip-scrap-name (scrap)
  &quot;Strip mode strings, ellipsis and white space from SCRAP and return
the result.&quot;
  (let ((mode-string (string-match noweb-mode-string-regexp scrap))
	(ellipsis (string-match &quot;\\.\\.\\.&quot; scrap)))
    (when (or mode-string ellipsis)
      (let* ((length (length scrap))
	     (end (min (or mode-string length) (or ellipsis length))))
	(setq scrap (substring scrap 0 end))))
    (noweb-trim scrap 'both)))


(defun noweb-extract-scrap-name-from-point ()
  &quot;Get the scrap name around point. Strip mode string and ellipsis
if present (mode string must follow ellipsis).&quot;
  (let ((start (or (noweb-scrap-name-start) (error &quot;No scrap name start&quot;)))
	(end (or (noweb-scrap-name-end) (error &quot;No scrap name end&quot;))))
    (noweb-strip-scrap-name (buffer-substring start end))))


(defun noweb-build-scrap-regexp (scrap-name what)
  &quot;Build a regular expression for matching uses, definitions
or both of scrap SCRAP-NAME.  WHAT is a symbol.  It is `definition' if
definitions should be searched, `use' if uses should be searched, and
`definition-and-use' when both should be searched.&quot;
  (setq scrap-name (concat &quot;\\(&quot; (regexp-quote scrap-name) &quot;.*\\)&quot;))
  (case what
    (use 
     (concat noweb-scrap-name-start-regexp scrap-name 
	     noweb-scrap-use-name-end-regexp))
    (definition 
      (concat &quot;^&quot; noweb-scrap-name-start-regexp scrap-name 
	      noweb-scrap-defn-name-end-regexp))
    (t (concat noweb-scrap-name-start-regexp scrap-name 
	       noweb-scrap-name-end-regexp))))



;;; Jumping to scraps.

(defun noweb-recenter ()
  &quot;Recenter without redrawing the window.&quot;
  (let ((prefix-arg t))
    (recenter (/ (window-height) 2))))


(defun noweb-jump (direction &amp;optional start-at-bobp)
  &quot;Search in `direction' for the next or previous occurrence of 
the scrap name at point.  If `start-at-bobp' is not nil, begin the
search at `point-min'.&quot;
  (unless (noweb-in-scrap-name-p)
    (error &quot;Not in a scrap name&quot;))
  (let* ((scrap (noweb-extract-scrap-name-from-point))
	 (regexp (noweb-build-scrap-regexp scrap 'definition-and-use))
	 (search-fn (if (eq direction 'forward) 
			're-search-forward 're-search-backward)))
    (if (eq direction 'forward)
	(if start-at-bobp 
	    (goto-char (point-min))
	  (end-of-line))
      (beginning-of-line))
    (unless (funcall search-fn regexp nil t)
      (error &quot;No match found&quot;))
    (goto-char (match-beginning 1))
    (when outline-minor-mode (show-all))
    (noweb-recenter)))


(defun noweb-jump-to-first-occurrence ()
  &quot;Jump to the first occurrence of scrap at point in the current buffer.&quot;
  (interactive)
  (noweb-jump 'forward 'start-at-bobp))


(defun noweb-jump-to-next-occurrence (&amp;optional start-at-bobp)
  &quot;Jump to the next occurrence of scrap at point in current buffer.&quot;
  (interactive)
  (noweb-jump 'forward))


(defun noweb-jump-to-previous-occurrence ()
  &quot;Jump to previous occurrence of scrap at point in current buffer.&quot;
  (interactive)
  (noweb-jump 'backward))



;;; Menu activation functions.

(defun noweb-in-code-chunk-p ()
  &quot;Return T if point is in a code chunk.&quot;
  (save-excursion
    (beginning-of-line)
    (while (and (not (bobp))
                (not (looking-at noweb-text-start-regexp))
                (not (looking-at noweb-code-start-regexp)))
      (previous-line 1)
      (beginning-of-line))
    (looking-at noweb-code-start-regexp)))


(defun noweb-exists-previous-scrap-p ()
  &quot;Return t if a previous use of scrap at point exists.&quot;
  (let ((scrap (noweb-extract-scrap-name-from-point)))
    (save-excursion
      (beginning-of-line)
      (re-search-backward (noweb-build-scrap-regexp scrap 'definition-and-use)
			  nil t))))
                     

(defun noweb-exists-next-scrap-p ()
  &quot;Return t if a next use of scrap at point exists.&quot;
  (let ((scrap (noweb-extract-scrap-name-from-point)))
    (save-excursion
      (end-of-line)
      (re-search-forward (noweb-build-scrap-regexp scrap 'definition-and-use)
			 nil t))))


                     
;;; Listing occurrences of a scrap name

(defun noweb-list-all-definitions ()
  &quot;Pop up an `occur' buffer that lists all definitions of the scrap
at point.&quot;
  (interactive)
  (let ((scrap (noweb-extract-scrap-name-from-point)))
    (list-matching-lines (noweb-build-scrap-regexp scrap 'definition))))


(defun noweb-list-all-uses ()
  &quot;Pop up an `occur' buffer that lists all uses of the scrap at point.&quot;
  (interactive)
  (let ((scrap (noweb-extract-scrap-name-from-point)))
    (list-matching-lines (noweb-build-scrap-regexp scrap 'use))))


(defun noweb-list-all-uses&amp;definitions ()
  &quot;Pop up an `occur' buffer that lists all uses and definitions of the 
scrap at point.&quot;
  (interactive)
  (let ((scrap (noweb-extract-scrap-name-from-point)))
    (list-matching-lines (noweb-build-scrap-regexp scrap 'definition-and-use))))



(defadvice font-lock-fontify-buffer (around noweb-font-lock-buffer first freeze)
  (if noweb-mode
      (noweb-fontify-buffer)
    ad-do-it))


(defun noweb-revert-buffer (ignore-auto no-confirm)
  &quot;Function used as REVERT-BUFFER-FUNCTION in noweb mode. This
solves the problem that minor modes are lost when reverting 
webs (which happens automatically when pcl-cvs is used.&quot;
  (setq revert-buffer-function nil)
  (revert-buffer ignore-auto no-confirm)
  (noweb-mode))



;;; Spell checking

(defun noweb-ispell-function ()
  &quot;Call `ispell-region' on either the active region, if any, or on all
text parts of this buffer beginning with the text part point is in or,
if we are in a code part, the text part in front of it.  Spell check
ends when the ispell process is killed (ispells `q' command).

Note that the XEmacs toolbar icon invokes this function in noweb
buffers.

This function `misuses' the variables `ispell-skip-tib',
`ispell-tib-ref-beginning' and `ispell-tib-ref-end' to let ispell skip
over `[[...]]' references in text parts.&quot;
  (interactive)
  (let ((ispell-skip-tib t)
	(ispell-tib-ref-beginning &quot;\\[\\[&quot;)
	(ispell-tib-ref-end &quot;]]&quot;))
    (if (region-active-p)
	(ispell-region (region-beginning) (region-end))
      (let ((text-start (or (re-search-backward noweb-text-start-regexp nil t)
			    (point-min))))
	(block 'spell-check
	  (noweb-for-all-text-parts text-start
	    (ispell-region start end)
	    (when (null (symbol-value 'ispell-process))
	      (return-from 'spell-check))))))))



;;; Annotations

(defun noweb-search (regexp search-fn)
  (let ((found (save-excursion (funcall search-fn regexp nil t))))
    (when (and (not found)
	       (y-or-n-p &quot;Nothing found. Re-build annotations? &quot;))
      (noweb-annotate-scraps)
      (setq found (save-excursion (funcall search-fn regexp nil t))))
    (unless found
      (error &quot;Nothing found.&quot;))
    (goto-char (match-beginning 1))
    (noweb-recenter)))


(defun noweb-search-forward (regexp event)
  &quot;Function called when a down arrow annotation is clicked.&quot;
  (goto-char (window-start))
  (next-line (event-y event))
  (end-of-line)
  (noweb-search regexp 're-search-forward))


(defun noweb-search-backward (regexp event)
  &quot;Function called when an up arrow annotation is clicked.&quot;
  (goto-char (window-start))
  (next-line (event-y event))
  (noweb-search regexp 're-search-backward))


(defun noweb-add-annotation (pos glyph mask regexp function)
  (let ((annotation (make-annotation glyph pos 'outside-margin
				     nil t mask)))
    (set-annotation-data annotation regexp)
    (set-annotation-action annotation function)))


(defun noweb-add-annotations-to-scrap (scrap prev next)
  &quot;Add marginal annotations to all scrap definitions and uses in
the current buffer.&quot;
  (let ((pos (cadr scrap)))
    (when prev
      (let ((glyph outline-up-arrow)
	    (mask outline-up-arrow-mask)
	    (regexp (noweb-build-scrap-regexp (car scrap) 'definition-or-use)))
	(noweb-add-annotation pos glyph mask regexp 'noweb-search-backward)
	(noweb-add-annotation pos (if (nth 1 (cdr prev)) &quot;d &quot; &quot;u &quot;) nil regexp 
			      'noweb-search-backward)))
    (when next
      (let ((glyph outline-down-arrow)
	    (mask outline-down-arrow-mask)
	    (regexp (noweb-build-scrap-regexp (car scrap) 'definition-or-use)))
	(noweb-add-annotation pos glyph mask regexp 'noweb-search-forward)
	(noweb-add-annotation pos (if (nth 1 (cdr next)) &quot;d &quot; &quot;u &quot;) nil regexp 
			      'noweb-search-forward)))))
					

(defun noweb-set-left-margin ()
  &quot;Make sure that the left margin width is at least NOWEB-LEFT-MARGIN-WIDTH
wide.&quot;
  (let* ((buffer (current-buffer))
	 (left-margin (specifier-specs left-margin-width buffer)))
    (when (or (null left-margin)
	      (&lt; left-margin noweb-left-margin-width))
      (add-spec-to-specifier left-margin-width noweb-left-margin-width buffer))))
  

(defun noweb-set-margin-face ()
  &quot;Set the left margin background.&quot;
  (set-face-background 'left-margin noweb-left-margin-background-color))


(defun noweb-annotate-scraps ()
  &quot;For each scrap in the current buffer, insert annotations that let
you jump to the next and previous uses and definitions of the same
scrap.&quot;
  (interactive)
  (noweb-set-left-margin)
  (noweb-set-margin-face)
  (mapc 'delete-annotation (annotation-list))
  (flet ((name/point&lt; (x y) (if (string= (car x) (car y))
				(&lt; (cadr x) (cadr y))
			      (string&lt; (car x) (car y))))
	 (scrap= (x y) (string= (car x) (car y))))
    (let* ((noweb-use-all-buffers-p nil)
	   (scraps (sort (noweb-scrap-name-alist) 'name/point&lt;)))
      (while scraps
	(let ((seq (car scraps)) prev)
	  (while (and scraps (scrap= (car scraps) seq))
	    (let ((current (car scraps))
		  (next (and (scrap= (cadr scraps) seq) 
			     (cadr scraps))))
	      (noweb-add-annotations-to-scrap current prev next)
	      (setq scraps (cdr scraps) prev current))))))))



;;; Use of different fonts for code and text parts.

(defun noweb-change-face (face locale to-face to-locale)
  &quot;Copy all interesting font properties from `fron-face' in locale
`from-locale' to `to-face' in locale `to-locale'.  At the moment, only
fonts are copied.  Note that `copy-face' doesn't change the face in
place, i.e. changing an existing face with `copy-face' doen't not have
effect of changing the appearance of all text in a buffer that had the
previous face.&quot;
  (let ((font (face-font to-face to-locale)))
    (when font
      (set-face-font face font locale))))


(defun noweb-toggle-fonts (&amp;optional force-on)
  &quot;Toggle use of different faces for code and text chunks. For text 
chunks we use the default face, for code chunks `noweb-code-face' is
used Changing faces is done by changing properties of these fonts in
the web buffer with the effect of chnages taking place immediately.

Faces to uses can be customized. `noweb-custom-text-face' contains the
customized text face, `noweb-custom-code-face' contains the face to
use for code chunks.  Per default, both fonts are equal to the default
font.&quot;
  (interactive)
  (setq noweb-fontify-chunks (or force-on (not noweb-fontify-chunks)))
  (let ((buffer (current-buffer)))
    (if noweb-fontify-chunks
	(progn
	  (noweb-change-face 'default buffer 'noweb-custom-text-face 'global)
	  (noweb-change-face 'noweb-code-face buffer'noweb-custom-code-face 'global))
      (noweb-change-face 'default buffer 'default 'global)
      (noweb-change-face 'noweb-code-face buffer 'default 'global))))


(defun noweb-re-fontify-code-part ()
  &quot;Re-highlight the current code part.&quot;
  (interactive)
  (unless (noweb-in-code-chunk-p)
    (error &quot;Not in a code chunk.&quot;))
  (let ((start (save-excursion 
		 (re-search-backward noweb-code-start-regexp nil t)
		 (1+ (match-end 0))))
	(end (or (save-excursion 
		   (re-search-forward noweb-text-start-regexp nil t))
		 (point-max))))
    (font-lock-unfontify-region start end)
    (noweb-fontify-region start end)))



;;; Narrowing

(defun noweb-narrow-to-code-part ()
  &quot;Narrow buffer to current code part.&quot;
  (interactive)
  (unless (noweb-in-code-chunk-p)
    (error &quot;Not in a code chunk.&quot;))
  (let ((start (save-excursion 
		 (re-search-backward noweb-code-start-regexp nil t)
		 (1+ (match-end 0))))
	(end (or (save-excursion 
		   (re-search-forward noweb-text-start-regexp nil t))
		 (point-max))))
    (narrow-to-region start (1- end))))



;;; Things done when this file is loaded.
  
(unless noweb-mode-map
  (setq noweb-mode-map (make-sparse-keymap))
  (define-key noweb-mode-map &quot;&lt;&quot; 'noweb-electric-&lt;)
  (define-key noweb-mode-map &quot;[&quot; 'noweb-electric-bracket)
  (define-key noweb-mode-map &quot;\t&quot; 'noweb-complete-scrap)
  (let ((map (make-sparse-keymap)))
    (define-key map &quot;\C-f&quot; 'noweb-re-fontify-code-part)
    (define-key map &quot;\C-n&quot; 'noweb-jump-to-next-occurrence)
    (define-key map &quot;\C-r&quot; 'noweb-make-region-reference)
    (define-key map &quot;\C-c&quot; 'noweb-narrow-to-code-part)
    (define-key map &quot;\C-p&quot; 'noweb-jump-to-previous-occurrence)
    (define-key noweb-mode-map noweb-prefix-key map)))


(defun noweb-install-font-lock-keywords ()
  &quot;In FSF Emacs 19.31 font-lock, defaults are stored in a let binding
in `font-lock- defaults-alist'.  This means that we have to do
some kludge.&quot;
  (let ((references (list noweb-font-lock-ref-regexp 0 'noweb-ref-face t))
	(uses (list noweb-font-lock-use-regexp 0 'noweb-use-face t))
	(definitions (list noweb-font-lock-definition-regexp 0 'noweb-defn-face t)))
    (loop for keywords in noweb-text-keywords
	  when (boundp keywords)
	  do (progn
	       (set keywords (cons references (symbol-value keywords)))
	       (set keywords (cons definitions (symbol-value keywords)))))
    (loop for keywords in noweb-code-keywords
	  when (boundp keywords)
	  do (set keywords (cons uses (symbol-value keywords))))))


;; Changes between using fonts and colors are done by setting variables,
;; then calling `font-lock-mode'.  This hook makes sure that we use the
;; right faces for noweb.
(defun noweb-font-lock-mode-hook-fn ()
  (when (and noweb-mode noweb-fontify-chunks)
    (noweb-toggle-fonts 'on)))

(add-hook 'font-lock-mode-hook 'noweb-font-lock-mode-hook-fn)



(unless (assq 'noweb-mode minor-mode-alist)
  (push '(noweb-mode noweb-mode-indicator) minor-mode-alist)
  (push (cons 'noweb-mode noweb-mode-map) minor-mode-map-alist)
  (noweb-install-font-lock-keywords))

(run-hooks 'noweb-load-hook)
(provide 'noweb)

;;; noweb.el ends here
</PRE>


<HR>
<A HREF="http://xp8.dejanews.com/getdoc.xp?recnum=9801476&server=db97p2x&CONTEXT=866586956.19181&hitnum=6"><IMG ALT="[Previous]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/prevart.gif"></A>
<A HREF="http://xp8.dejanews.com/getdoc.xp?recnum=9801474&server=db97p2x&CONTEXT=866586956.19181&hitnum=8"><IMG ALT="[Next]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/nextart.gif"></A>
<A HREF="http://xp8.dejanews.com/dnquery.xp?search=next&site=dn&offsets=&CONTEXT=866586956.19181"><IMG ALT="[Current Results]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/currsr.gif"></A>
<A HREF="http://xp8.dejanews.com/dnquery.xp?search=thread&filter=&svcclass=dncurrent&threaded=1&CONTEXT=866586956.19181&HIT_CONTEXT=866586956.19181&HIT_NUM=7&recnum=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e%231/13"><IMG ALT="[Get Thread]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/thread.gif"></A>
<A HREF="http://search.dejanews.com/profile.xp?author=Gerd%20Moellmann%20%3cmmann@ibm.net%3e"><IMG ALT="[Author Profile]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/authorprof.gif"></A>
<A HREF="http://postnews.dejanews.com/post.xp?NG=gnu.emacs.sources&SUB=Re:%20noweb.el%20(please%20read%20comment%20there)&REF=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e&server=db97p2x&recnum=%3c87pvtubgnt.fsf@gerd.freebsd.ibm.net%3e"><IMG ALT="[Post]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/postrep.gif"></A>
<A HREF="http://postnews.dejanews.com/post.xp"><IMG ALT="[Post]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/postart.gif"></A>
<A HREF="mailto:mmann@ibm.net"><IMG ALT="[Reply]" BORDER=0 WIDTH=43 HEIGHT=59 SRC="http://www.dejanews.com/gifs/email.gif"></A>
<HR SIZE=1 NOSHADE>
<TABLE WIDTH=540 CELLSPACING=0 CELLPADDING=0>
<TR ALIGN="CENTER"><TD>
<A HREF="http://www.dejanews.com/">Home</A> &#160;
<A HREF="http://www.dejanews.com/forms/dnq.html">Power Search</A> &#160;
<A HREF="http://postnews.dejanews.com/post.xp">Post to Usenet</A> &#160;
<A HREF="http://www.dejanews.com/help/dnfaq.html">Ask DN Wizard</A> &#160;
<A HREF="http://www.dejanews.com/help/dnarticle_help.html">Help</A><BR></TD>
</TR>
<TR ALIGN="CENTER"><TD>
<FONT SIZE=-1>
<A HREF="http://www.dejanews.com/forms/dnsurvey.shtml">Give us feedback!</A> &#160;|&#160;
<A HREF="http://www.dejanews.com/pr/ratecard.html">Advertising Info</A> &#160;|&#160;
<A HREF="http://www.dejanews.com/pr/dnpress.html">Press Releases</A> &#160;|&#160;
<A HREF="http://www.dejanews.com/pr/dnjobs.html">Jobs</A> &#160;|&#160;
<A HREF="http://www.dejanews.com/pr/dndn.html">Policy Stuff</A><BR>
Copyright &copy; 1995-97 <A HREF="http://www.dejanews.com/pr/dnabout.html">Deja News, Inc.</A> All rights reserved.
</FONT></TD></TR>
</TABLE>
</BODY></HTML>