;; comment.el
;;
;; Utility to comment/uncomment a line 
;;
;; Later: add facitlity to comment/uncomment a region
;;        add mode-sensitive comment strings 
;;
;; For C need a begin-strig, end-string pair 
;;     Pascal ...

(defvar c++-mode-auto-comment-string  "//- ")
(defvar lisp-mode-auto-comment-string ";;- ")
(defvar sh-mode-auto-comment-string  "#- ")
(defvar csh-mode-auto-comment-string  "#- ")
(defvar ksh-mode-auto-comment-string  "#- ")

(defun comment-line ()
"Insert a C++ style comment for the current line."
  (interactive)
  (let ((opoint (point))
	(comment-string c++-mode-auto-comment-string))
    (beginning-of-line)
    (insert comment-string)
    (goto-char (+ opoint (length comment-string)))
  (next-line 1)))


;; to uncomment
;; beginning of line 
;; if string match comment-char line 
;;    delete (length comment chars)
;;    .. set the point back ... to point - length 
;; setq point (< point length comment-chgar)
;;        
;(defun un-comment-line ()
;"Remove a C++ style comment from the current line."
;  (interactive)
;  (let ((opoint (point))
;	(comment-string c++-mode-auto-comment-string))
;    (beginning-of-line)
;    (insert comment-string)
;    (goto-char (+ opoint (length comment-string)))
;  (next-line 1)))


(global-set-key '(control f8)    'comment-line)
