;;; variable-apropos.el
;;; variable-apropos function
;;; bound to ^H-^V
(defun variable-apropos (string)
  "Like apropos but lists only symbols that are names of variables
that are user-modifiable."
  (interactive "sVariable apropos (regexp): ")
  (let ((message
      (let ((standard-output (get-buffer-create "*Help*")))
      (print-help-return-message 'identity))))
    (apropos string 'user-variable-p)
    (and message (message message))))

(define-key help-map "\C-v" 'variable-apropos)
;;; end variable-apropos.el
