;; include.el
;;
;; Visit the file named in a #include statement
;;
;; I copied most of the logic for the includer from the OOBR package 
;;
;;-------------------------------------------------------------------------
;;
;; To use a specific set of include paths, include statements similar 
;; to the following in your .emacs file. 
;;
;; ;  set 'my-include-dirs'     to any project specific directories. 
;; ;  set 'my-cpp-include-dirs' to compiler include directories 
;;
;; (setq my-include-dirs 
;;   (list
;;     (concat (getenv "EM_DEVPATH") "/include_public/")
;;     (concat (getenv "EM_DEVPATH") "/include_private/")
;;     (concat (getenv "ATIUM_DV_HOME") "/include_public/")
;;     (concat (getenv "ATIUM_DV_HOME") "/include_private/")
;;     '"/opt/OV/include/"))
;;
;; (setq my-cpp-include-dirs 
;;    '("/opt/SUNWspro/SC3.0/include/CC/"
;;      "/usr/include"))
;;
;;-------------------------------------------------------------------------


;;
;; This package uses the 'make-vpath-include-dirs' function to 
;; build a directory search list on the fly. 
;;

(defconst my-c++-include-regexp
  "[ \t/*]*#[ \t]*include[ \t]+\\([\"<]\\)\\([^\">]+\\)[\">]"
  "Regexp to match to C++ include file lines.  File name is grouping 2.  Type
of include, user-specified via double quote, or system-related starting with
'<' is given by grouping 1.")

(defvar my-cpp-include-dirs '("/usr/include/")
  "*Ordered list of include directories by default searched by C preprocessor.
Each directory must end with a directory separator.  See also
'c++-include-dirs'.")

(defvar my-include-dirs nil
  "*Ordered list of directories to search for C++ include files.
Each directory must end with a directory separator.  Directories normally
searched by the C++ pre-processor should be set instead in
'c++-cpp-include-dirs'.")


(defun locate-include-file (&optional other-win)
  "If point is on an include file line, try to display file.
Return non-nil iff an include file line, even if file is not found.
Look for include file in 'c++-cpp-include-dirs' and in directory list
'c++-include-dirs'."
  (interactive)
  (locate-include-file-in-path my-include-dirs))

(defun locate-include-file-in-path (pathlist &optional other-window)
"If point is on an include file line, try to display file.
Return non-nil iff an include file line, even if file is not found.
Look for include file in 'c++-cpp-include-dirs' and in directory list
'c++-include-dirs'."
  (let ((opoint (point)))
    (beginning-of-line)
    (if (looking-at my-c++-include-regexp)
	(let ((incl-type (string-to-char
			  (buffer-substring (match-beginning 1)
					    (1+ (match-beginning 1)))))
	      (file (buffer-substring (match-beginning 2) (match-end 2)))
	      (path)
	      (dir-list pathlist)
	      );(found))
	  (goto-char opoint)
	  (setq dir-list (if (= incl-type ?<)
			     (append dir-list my-cpp-include-dirs)
			   (cons (file-name-directory buffer-file-name)
				 dir-list)))
;	  (while dir-list
;	    (setq path (concat (car dir-list) file)
;		  dir-list (if (setq found (file-exists-p path))
;			       nil
;			     (cdr dir-list))))
;	  ;;
;	  ;; If found, display file
;	  ;;
;	  (if found

;(with-output-to-temp-buffer "*include-trace*"
;(princ "Include_dirs:")
;(princ dir-list)
;(terpri))

	  (if (setq path (search-for-file file dir-list))
	      (if (file-readable-p path)
		  (find-file path)
		(beep)
		(message "(Includer):  Include file '%s' unreadable." path))
	    (beep)
	    (message "(Includer):  Include file '%s' not found." file))
	  path)
      (goto-char opoint)
      (beep)
      (message "(Includer) : Not a #include line"))))



(defun add-include-directory (path)
"Add a directory to the `my-include-dirs' list of directories to search
for included files"
  (interactive "fPath to add: ")
  (setq my-include-dirs (append my-include-dirs path)))


(defun search-for-file (filename dir-list)
"Search for the file in one of the directories specified.
Return the name of the file if found, nil if not."
  (let ((path)
	(found))
;(with-output-to-temp-buffer "*search-trace*"
;(princ "search-for-file:\n")
;(princ "orig-list:")
;(princ dir-list)
;(princ "\n")
    (while dir-list
      (setq path (concat (car dir-list) filename)
	  dir-list (if (setq found (file-exists-p path))
		       nil
		     (cdr dir-list))))
;(princ path)
;(princ "\n")
;)
  (if found
      path
    nil)))

;;
(provide 'include)