;;
;; c2ps.el 
;;
;; Xemacs interface for c2ps 
;;
;; 

;;;;============================ c2ps =============================

(defvar c2ps-printer "" "Parameter string - name of printer c2ps should use")
(defvar c2ps-col     "-2" "Parameter string - number of columns per single page")
(defvar c2ps-c       (if (member mode-name c-list-of-mode-names) "" "-c")
  "Parameter string - C/C++ highlight flag")
(defvar c2ps-a       "" "Parameter string - adjusted multiple line comment printing")
(defvar c2ps-i       "" "Parameter string - iso8859-1 encoding support flag")
(defvar c2ps-m       "" "Parameter string - print current date instead of last modification date

When this flag is unset and you are printing some file
its last modification date will be printed.
Otherwise c2ps will use current date")
(defvar c2ps-n       "" "Parameter string - when set line numbering is disabled")
(defvar c2ps-u       "" "Parameter string - when set header drawing is disabled")
(defvar c2ps-w       "" "Parameter string - when set long line wrapping is disabled")
(defvar c2ps-r       "-r" "Parameter string - when set frame will be drawn round each column")
(defvar c2ps-f       "" "Parameter string - font size")
(defvar c2ps-s       "" "Parameter string - space between lines")
(defvar c2ps-l       "" "Parameter string - lines per column")
(defvar c2ps-d       "-d 0.40" "Parameter string - coefficient of comments dimming")
(defvar c2ps-t       "" "Parameter string - constant number of spaces per tab")
(defvar c2ps-p       "-p Letter"              "Parameter string - paper type")
(defvar c2ps-P       "-P Courier-BoldOblique" "Parameter string - preprocessor font")
(defvar c2ps-C       "-C Helvetica-Oblique"   "Parameter string - comment font")
(defvar c2ps-S       "-S Courier-Oblique"     "Parameter string - string font")
(defvar c2ps-K       "-K Courier-Bold"        "Parameter string - keyword font")
(defvar c2ps-N       "-N Times-Roman"         "Parameter string - line number font")
(defvar c2ps-F       "-F Courier"             "Parameter string - default font")
;(defvar c2ps-C       "-C Helvetica-Oblique"   "Parameter string - comment font")
;(defvar c2ps-S       "-S Courier-Oblique"     "Parameter string - string font")
;(defvar c2ps-K       "-K Courier-Bold"        "Parameter string - keyword font")
;(defvar c2ps-N       "-N Times-Roman"         "Parameter string - line number font")
;(defvar c2ps-F       "-F Courier"             "Parameter string - default font")


(make-variable-buffer-local 'c2ps-c)

(defun c2ps-print (beg end)
;;  (cond
;;   ((file-executable-p "c2ps")
    (shell-command-on-region
     beg
     end
     (format
      "c2ps %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s | lpr %s -h"
      c2ps-col c2ps-a c2ps-c c2ps-i c2ps-m c2ps-n c2ps-u c2ps-w c2ps-r c2ps-f c2ps-s c2ps-l
      c2ps-d c2ps-t c2ps-p c2ps-P c2ps-C c2ps-S c2ps-K c2ps-N c2ps-F c2ps-printer
      )
     nil
     nil)
    (kill-buffer
     (get-buffer "*Shell Command Output*"))
    (display-message 'progress "Successfully spooled"))
;;   (t (display-message "Can't execute c2ps"))))

(defun c2ps-region () "Prints region"
  (interactive)
  (c2ps-print (region-beginning) (region-end)))

(defun c2ps-buffer () "Prints buffer"
  (interactive)
  (c2ps-print (point-min) (point-max)))

(defun c2ps-file (file) "Prints file"
  (interactive "fFile for c2ps to print: ")
;;  (cond
;;   ((file-executable-p "c2ps")
    (shell-command
     (format
      "c2ps %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s | lpr %s -h"
      file ;(read-file-name "File for c2ps to print: ")
      c2ps-col c2ps-a c2ps-c c2ps-i c2ps-m c2ps-n c2ps-u c2ps-w c2ps-r c2ps-f c2ps-s c2ps-l
      c2ps-d c2ps-t c2ps-p c2ps-P c2ps-C c2ps-S c2ps-K c2ps-N c2ps-F c2ps-printer
      ))
    (kill-buffer
     (get-buffer "*Shell Command Output*"))
    (display-message 'progress "Successfully spooled"))
;;   (t (display-message 'progress "Can't execute c2ps"))))

(defun c2ps-menu-filter (items)
  items)

(defvar c2ps-menu
  '("c2ps" :filter c2ps-menu-filter
    ["Print Buffer" c2ps-buffer t]
    ["Print Region" c2ps-region :active (region-exists-p) ]
    ["Print File  " c2ps-file t]
    "-----"
    "-----"
    "-----"
    ["Highlight C/C++" (setq c2ps-c (if (string= "-c" c2ps-c) "" "-c"))
     :style toggle
     :selected (not (string= "-c" c2ps-c))
     ]
    ["Adjust comments" (setq c2ps-a (if (string= "-a" c2ps-a) "" "-a"))
     :style toggle
     :selected (not (string= "-a" c2ps-a))
     ]
    ["Number lines" (setq c2ps-n (if (string= "-n" c2ps-n) "" "-n"))
     :style toggle
     :selected (not (string= "-n" c2ps-n))
     ]
    ["Wrap long lines" (setq c2ps-w (if (string= "-w" c2ps-w) "" "-w"))
     :style toggle
     :selected (not (string= "-w" c2ps-w))
     ]
    ["Header" (setq c2ps-u (if (string= "-u" c2ps-u) "" "-u"))
     :style toggle
     :selected (not (string= "-u" c2ps-u))
     ]
    ["Frame" (setq c2ps-r (if (string= "-r" c2ps-r) "" "-r"))
     :style toggle
     :selected (string= "-r" c2ps-r)
     ]
    ["ISO 8859-1" (setq c2ps-i (if (string= "-i" c2ps-i) "" "-i"))
     :style toggle
     :selected (not (string= "-i" c2ps-i))
     ]
    ["Last modified" (setq c2ps-m (if (string= "-m" c2ps-m) "" "-m"))
     :style toggle
     :selected (not (string= "-m" c2ps-m))
     ]
    "-----"
    ("Fonts"
     ["Default..."
      (setq c2ps-F
	    (format "-F %s"
		    (read-from-minibuffer "Default font: "
					  (replace-in-string c2ps-F "-F " ""))))
      t
      ]
     "-----"
     ["Comment..."
      (setq c2ps-C
	    (format "-C %s"
		    (read-from-minibuffer "Comment font: "
					  (replace-in-string c2ps-C "-C " ""))))
      t
      ]
     ["Keyword..."
      (setq c2ps-K
	    (format "-K %s"
		    (read-from-minibuffer "Keyword font: "
					  (replace-in-string c2ps-K "-K " ""))))
      t
      ]
     ["Line number..."
      (setq c2ps-N
	    (format "-N %s"
		    (read-from-minibuffer "Line numbers font: "
					  (replace-in-string c2ps-N "-N " ""))))
      t
      ]
     ["Preprocessor..."
      (setq c2ps-P
	    (format "-P %s"
		    (read-from-minibuffer "Preprocessor font: "
					  (replace-in-string c2ps-P "-P " ""))))
      t
      ]
     ["String..."
      (setq c2ps-S
	    (format "-S %s"
		    (read-from-minibuffer "String font: "
					  (replace-in-string c2ps-S "-S " ""))))
      t
      ]
     )
    ["Font size..."
     (progn
       (setq c2ps-f
	     (format "-f %s"
		     (read-from-minibuffer "Font size: "
					   (replace-in-string c2ps-f "-f " ""))))
       )
     ;;  :suffix  " 10"
     t
     ]
;;;(relabel-menu-item '("c2ps" "Font size...") (format "Font size (%s) ..." c2ps-f))
    "-----"
    ("Columns"
     [
      "1" (setq c2ps-col "-1")
      :style radio
      :selected (string= "-1" c2ps-col)
      ]
     ["2" (setq c2ps-col "-2")
      :style radio
      :selected (string= "-2" c2ps-col)
      ]
     ["4" (setq c2ps-col "-4")
      :style radio
      :selected (string= "-4" c2ps-col)
      ]
     )
    ["Lines per column..."
     (setq c2ps-l
	   (format "-l %s"
		   (read-from-minibuffer "Lines per column: "
					 (replace-in-string c2ps-l "-l " ""))))
     ;;:suffix " : 0"
     t
     ]
    ["Space between lines..."
     (setq c2ps-s
	   (format "-s %s"
		   (read-from-minibuffer "Space between lines: "
					 (replace-in-string c2ps-s "-s " ""))))
     t
     ]
    ["Dim comments..."
     (setq c2ps-d
	   (format "-d %s"
		   (read-from-minibuffer
		    "Dim coefficient [0.00=black...1.00=white] : "
		    (replace-in-string c2ps-d "-d " ""))))
     t
     ]
    ["Tab size..."
     (setq c2ps-t
	   (format "-t %s"
		   (read-from-minibuffer "Tab size: "
					 (replace-in-string c2ps-t "-t " ""))))
     t
     ]
    "-----"
    ["Printer..."
     (setq c2ps-printer
	   (format "-P%s"
		   (read-from-minibuffer "Printer name: "
					 (replace-in-string c2ps-printer "-P" ""))))
     ;;:suffix " : ip"
     t
     ]
    ("Paper"
     ["A4" (setq c2ps-p "-p A4")
      :style radio
      :selected (string= "-p A4" c2ps-p)
      ]
     ["Letter" (setq c2ps-p "-p Letter")
      :style radio
      :selected (string= "-p Letter" c2ps-p)
      ]
     )
    "-----"
    ["Remove c2ps menu from menubar"
     (delete-menu-item '("c2ps"))
     t
     ]
    )
  "c2ps menu")

(defun c2ps-add-menubar-entry () "Adds c2ps menu to the menubar"
  (interactive)
  (add-submenu nil c2ps-menu))

(c2ps-add-menubar-entry)

