;;;; xfile.el --- popup file browser

;;; Author: Bruce Israel <israel@starbase.mitre.org>
;;; Maintainer: David Konerding (rafael@cse.ucsc.edu)
;;; Modifications by: 
;;; Modified: 2/95

;;; Copyright (C) 1995 Nobody

;;; This file is not part of GNU Emacs.

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; LCD Archive Entry
;;; xfile|David Konerding|rafael@cse.ucsc.edu
;;; |popup file browser
;;; |$Date: 1994/05/13 14:14:37 $|$Revision: 1.4 $|

;;;; Commentary:

;  
; When the mouse button invoking x-find-file is pressed, a menu of the
; files in the current directory will pop up.  If a file is selected, that
; file is put up on the screen for editing.  If the button is pressed over
; a directory and held, a menu for that directory will be popped up, where
; it is possible to select a file or directory by releasing the mouse
; button.  Through alternatively pressing and releasing the mouse button,
; it is possible to travel throughout the system directories until the
; desired file is found.
;
;Bruce

; I modified this a little because it didn't work out of the box with
; Emacs-19.28.  I bind it to a mouse-event using:
;(global-set-key [C-M-down-mouse-1] 'x-find-file)
; quite handy (for us lazy folks)

;; wgd - change this 
;; 
;; display the menu of all files. 
;; get the result
;; if the result is a directory, expand it and contineu 
;; if the result is a file, load it (or return it .. )
;; if reslt is nil, return

;; this code builds a popup ... (sortof) but the 
;; entries are disabled ... need to find out how to 
;; make the entries selectable 

(defun x-get-filename (dir arg)
  "Find a file via menus in X.  The selected file is returned.
   DIR is the default directory to begin the search in, and ARG
   is the argument passed in by the X mouse software"
  (let (menu files result key file limit (continue t))
    ;(while continue
      (setq limit (/ (frame-height) 2)
	    files (cons dir (directory-files dir))
	    menu (list "Here" (vector "abc" '(find-file "abc") t)))
;      (while (setq files (cdr files))
;	(setq file (car files)
;	      key t)
;	(if (file-directory-p (concat dir file))
;	    (setq key t
;		  file (concat file "/")))
;	(if (string-equal file "//") (setq file "/"))
	;(setq menu (append menu (vector file '(princ "a") key))))
	;(setq menu (append menu file)))
	;(setq menu (cons (cons file (cons key file)) menu)))
	;(setq menu (cons menu (cons file (cons key file)))))
	;(setq menu (append menu (vector file '' '(princ "a") key))))

;      (if (> (length menu) limit)
;	  (let ((pane nil) (panes nil) (count 0))
;	    (setq limit (/ (length menu) (1+ (/ (length menu) limit))))
;	    (while menu
;	      (setq pane (cons (car menu) pane))
;	      (setq menu (cdr menu)
;		    count (1+ count))
;	      (and (> count limit)
;		   (setq panes (cons (cons dir pane) panes))
;		   (setq pane nil
;			 count 0)))
;	    (if pane (setq panes (cons (cons dir pane) panes)))
;	    (setq menu panes))
;	(setq menu (cons (cons dir (nreverse menu)) nil)))

;      (setq result (x-popup-menu arg (cons "find file menu" menu)))
;      (setq result (popup-menu (cons "find file menu" menu) arg))
      (setq result (popup-menu menu))
      (setq file (expand-file-name (concat dir result)))
      (cond ((null result) 		(setq continue nil))
	    (t                          (setq continue nil result file))
	    (t 				(setq continue t dir file))))
    result)

; original 
;(defun x-get-filename (dir arg)
;  "Find a file via menus in X.  The selected file is returned.
;   DIR is the default directory to begin the search in, and ARG
;   is the argument passed in by the X mouse software"
;  (let (menu files result key file limit (continue t))
;    (while continue
;      (setq limit (/ (frame-height) 2)
;	    menu (list (cons (format "SELECT %s" dir) (cons 'ACCEPT dir)))
;	    files (cons nil (directory-files dir)))
;      (while (setq files (cdr files))
;	(setq file (car files)
;	      key 'ACCEPT)
;	(if (file-directory-p (concat dir file))
;	    (setq key 'EXPAND
;		  file (concat file "/")))
;	(if (string-equal file "//") (setq file "/"))
;	(setq menu (cons (cons file (cons key file)) menu)))
;      (if (> (length menu) limit)
;	  (let ((pane nil) (panes nil) (count 0))
;	    (setq limit (/ (length menu) (1+ (/ (length menu) limit))))
;	    (while menu
;	      (setq pane (cons (car menu) pane))
;	      (setq menu (cdr menu)
;		    count (1+ count))
;	      (and (> count limit)
;		   (setq panes (cons (cons dir pane) panes))
;		   (setq pane nil
;			 count 0)))
;	    (if pane (setq panes (cons (cons dir pane) panes)))
;	    (setq menu panes))
;	(setq menu (cons (cons dir (nreverse menu)) nil)))
;;      (setq result (x-popup-menu arg (cons "find file menu" menu)))
;      (setq result (popup-menu (cons "find file menu" menu) arg))
;      (setq file (expand-file-name (concat dir (cdr result))))
;      (cond ((null result) 		(setq continue nil))
;	    ((eq (car result) 'ACCEPT)  (setq continue nil result file))
;	    (t 				(setq continue t dir file))))
;    result))

(defun x-find-file (event)
  "Select and edit a file using menus under X."
  (interactive "e")
  (let ((name (x-get-filename default-directory t)))
    (if name (find-file name))))

(provide 'xfile)

(global-set-key 'f10 'x-find-file)
